package com.xebialabs.deployit.plugin.wls.ci;

import static com.xebialabs.deployit.util.ExtendedStringUtils.getQuotedString;

import java.io.Serializable;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemLabel;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A reference to a JMS connection factory outside the current 
 * {@link WlsDomain WLS domain}.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "Foreign connection factory represents a connection factory that resides on another server, and which is accessible via JNDI.")
public class WlsForeignJmsConnectionFactory extends BaseConfigurationItem {

	@ConfigurationItemProperty(description = "The name of the foreign connection factory.", required = true)
	private String name;

	@ConfigurationItemProperty(description = "The name that the remote object will be bound to in the local server's JNDI tree.", required = true)
	private String localJNDIName;

	@ConfigurationItemProperty(description = "The name of the remote object that will be looked up in the remote JNDI directory.", required = true)
	private String remoteJNDIName;

	@ConfigurationItemProperty(description = "The foreign server in which the foreign connection factory is included.", required = true)
	private WlsForeignJmsServer parentForeignServer;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getLocalJNDIName() {
		return localJNDIName;
	}

	public void setLocalJNDIName(String localJNDIName) {
		this.localJNDIName = localJNDIName;
	}

	public String getRemoteJNDIName() {
		return remoteJNDIName;
	}

	public void setRemoteJNDIName(String remoteJNDIName) {
		this.remoteJNDIName = remoteJNDIName;
	}

	public WlsForeignJmsServer getParentForeignServer() {
		return parentForeignServer;
	}

	public void setParentForeignServer(WlsForeignJmsServer parentForeignServer) {
		this.parentForeignServer = parentForeignServer;
	}

}
