package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A set of JMS queues matched to the {@link WlsServer managed servers} in
 * a {@link WlsCluster cluster}.
 * <p>
 * For each managed server, a JMS queue of name <em>name</em>_<em>i</em> is
 * created, along with an associated error and malformed queue. Further, a 
 * distributed queue is created which distributes across the individual queues.
 * <p>
 * Use of queue sets is no longer recommended. Instead, it is preferable to create
 * a Migratable Target with simple queues targeted at it.    
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "A Weblogic JMS Queue Set")
public class WlsJmsQueueSet extends BaseConfigurationItem {

	@ConfigurationItemProperty(description = "The name of the queue. e.g. alsb2wlsqueue", required = true)
	private String name;

	@ConfigurationItemProperty(required = true)
	private String jndiName;

	@ConfigurationItemProperty(description = "The number of redelivery attempts a message can make before it is moved to the error destination.")
	private int redeliveryLimits;

	@ConfigurationItemProperty(description = "The JMS module the queue should be included in.", required = true)
	private WlsJmsModule parentModule;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getJndiName() {
		return jndiName;
	}

	public void setJndiName(String jndiName) {
		this.jndiName = jndiName;
	}

	public int getRedeliveryLimits() {
		return redeliveryLimits;
	}

	public void setRedeliveryLimits(int redeliveryLimits) {
		this.redeliveryLimits = redeliveryLimits;
	}

	public WlsJmsModule getParentModule() {
		return parentModule;
	}

	public void setParentModule(WlsJmsModule parentModule) {
		this.parentModule = parentModule;
	}

}
