package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

/**
 * A Work Manager in a {@link WlsDomain WLS domain}.
 * <p>
 * Work Managers should be application specific, i.e. not shared between
 * multiple applications running in a domain.
 * 
 * @see WlsMaximumThreadsConstraint
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "Work Manager that defines a set of request classes and thread constraints that manage work performed by WebLogic Server instances.")
public class WlsWorkManager extends BaseConfigurationItem {

	@ConfigurationItemProperty(description = "Name of the Work Manager", required = true)
	private String name;

	@ConfigurationItemProperty
	private WlsMaximumThreadsConstraint maximumThreadsConstraint;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}


	public WlsMaximumThreadsConstraint getMaximumThreadsConstraint() {
		return maximumThreadsConstraint;
	}

	public void setMaximumThreadsConstraint(WlsMaximumThreadsConstraint maximumThreadsConstraint) {
		this.maximumThreadsConstraint = maximumThreadsConstraint;
	}

}
