package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.artifact.mapping.WarMapping;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.Pair;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.StartApplicationStep;
import com.xebialabs.deployit.plugin.wls.step.StopApplicationStep;
import com.xebialabs.deployit.plugin.wls.step.WlsDeployArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.WlsUndeployArtifactStep;

public class WarToWlsServerMapper extends Mapper<War, WarMapping, WlsServer> {

	public WarToWlsServerMapper(Change<Deployment> c) {
		super(c);
	}

	public void generateUndeploySteps(List<Step> steps) {
		for (WarMapping m : getDeletedMappings()) {
			steps.add(new StopApplicationStep((WlsServer) m.getTarget(), (War) m.getSource()));
			steps.add(new WlsUndeployArtifactStep((WlsServer) m.getTarget(), (War) m.getSource()));
		}
		for (Pair<WarMapping, WarMapping> mPair : getModifiedMappings()) {
			steps.add(new StopApplicationStep((WlsServer) mPair.getFirst().getTarget(), (War) mPair.getFirst().getSource()));
			steps.add(new WlsUndeployArtifactStep((WlsServer) mPair.getFirst().getTarget(), (War) mPair.getFirst().getSource()));
		}
	}

	public void generateDeploySteps(List<Step> steps) {
		for (Pair<WarMapping, WarMapping> mPair : getModifiedMappings()) {
			steps.add(new WlsDeployArtifactStep((WlsServer) mPair.getFirst().getTarget(), (War) mPair.getFirst().getSource()));
		}
		for (WarMapping m : getAddedMappings()) {
			steps.add(new WlsDeployArtifactStep((WlsServer) m.getTarget(), (War) m.getSource()));
		}
	}

	public void generateStartSteps(List<Step> steps) {
		for (Pair<WarMapping, WarMapping> mPair : getModifiedMappings()) {
			steps.add(new StartApplicationStep((WlsServer) mPair.getFirst().getTarget(), (War) mPair.getFirst().getSource()));
		}
		for (WarMapping m : getAddedMappings()) {
			steps.add(new StartApplicationStep((WlsServer) m.getTarget(), (War) m.getSource()));
		}
	}

}
