package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsForeignJmsConnectionFactory;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsForeignJmsConnectionFactoryStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsForeignJmsConnectionFactoryStep;

public class WlsForeignJmsConnectionFactoryToWlsClusterMapper extends MappingAgnosticStepGeneratingMapper<WlsForeignJmsConnectionFactory, WlsCluster> {

	public WlsForeignJmsConnectionFactoryToWlsClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WlsForeignJmsConnectionFactory newSource, WlsCluster newTarget, List<Step> steps) {
		steps.add(new CreateWlsForeignJmsConnectionFactoryStep(newTarget.getDomain(), newSource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WlsForeignJmsConnectionFactory oldSource, WlsCluster oldTarget, List<Step> steps) {
		steps.add(new DestroyWlsForeignJmsConnectionFactoryStep(oldTarget.getDomain(), oldSource));
	}

}
