package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsModule;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsJmsModuleStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsJmsModuleStep;

public class WlsJmsModuleToWlsClusterMapper extends MappingAgnosticStepGeneratingMapper<WlsJmsModule, WlsCluster> {

	public WlsJmsModuleToWlsClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WlsJmsModule newSource, WlsCluster newTarget, List<Step> steps) {
		steps.add(new CreateWlsJmsModuleStep(newTarget, newSource));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WlsJmsModule oldSource, WlsCluster oldTarget, List<Step> steps) {
		steps.add(new DestroyWlsJmsModuleStep(oldTarget, oldSource));
	}

}
