package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.Collections;
import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsWorkManager;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsWorkManagerStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsWorkManagerStep;

public class WlsWorkManagerToWlsClusterMapper extends MappingAgnosticStepGeneratingMapper<WlsWorkManager, WlsCluster> {

	public WlsWorkManagerToWlsClusterMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WlsWorkManager newSource, WlsCluster newTarget, List<Step> steps) {
		steps.add(new CreateWlsWorkManagerStep(newSource, newTarget.getDomain(), Collections.singleton(newTarget)));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WlsWorkManager oldSource, WlsCluster oldTarget, List<Step> steps) {
		steps.add(new DestroyWlsWorkManagerStep(oldSource, oldTarget.getDomain()));
	}

}
