package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDataSource;

/**
 * Creates a {@link WlsDataSource JDBC data source}.
 */
@SuppressWarnings("serial")
public class CreateWlsDataSourceStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-datasource.py";

	public CreateWlsDataSourceStep(WlsCluster cluster, WlsDataSource wlsDataSource) {
		super("Create datasource " + wlsDataSource + " on cluster " + cluster, cluster.getDomain(), SCRIPT_RESOURCE_PATH, getArgs(cluster.getName(),
				wlsDataSource));
	}

	private static String[] getArgs(String targetname, WlsDataSource webLogicDatasource) {
		List<String> args = new ArrayList<String>();
		args.add(targetname);
		args.add(webLogicDatasource.getName());
		args.add(webLogicDatasource.getJndiName());
		args.add(webLogicDatasource.getUri());
		args.add(webLogicDatasource.getUserName());
		args.add(webLogicDatasource.getPassword());
		args.add(webLogicDatasource.getDriver());
		args.add(String.valueOf(webLogicDatasource.getInit()));
		args.add(String.valueOf(webLogicDatasource.getMax()));
		args.add(webLogicDatasource.getProperties());
		return args.toArray(new String[args.size()]);
	}

}
