package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsForeignJmsConnectionFactory;
import com.xebialabs.deployit.plugin.wls.ci.WlsForeignJmsServer;

/**
 * Creates a {@link WlsForeignJmsConnectionFactory Foreign JMS Connection Factory}.
 */
@SuppressWarnings("serial")
public class CreateWlsForeignJmsConnectionFactoryStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-foreign-connection-factory.py";

	public CreateWlsForeignJmsConnectionFactoryStep(WlsDomain domain, WlsForeignJmsConnectionFactory webLogicForeignJMSConnectionFactory) {
		super("Create Foreign Connection Factory " + webLogicForeignJMSConnectionFactory + " in domain " + domain, domain, SCRIPT_RESOURCE_PATH,
				getArgs(webLogicForeignJMSConnectionFactory));
	}

	private static String[] getArgs(WlsForeignJmsConnectionFactory webLogicForeignJMSConnectionFactory) {
		WlsForeignJmsServer parentForeignServer = webLogicForeignJMSConnectionFactory.getParentForeignServer();
		if (parentForeignServer == null) {
			throw new ResolutionException("Foreign JMS Connection Factory " + webLogicForeignJMSConnectionFactory
					+ " is not associated with any Foreign JMS Server");
		}
		if (parentForeignServer.getParentModule() == null) {
			throw new ResolutionException("Foreign JMS Server " + parentForeignServer.getParentModule() + " is not associated with any JMS Module");
		}

		List<String> args = new ArrayList<String>();
		args.add(webLogicForeignJMSConnectionFactory.getParentForeignServer().getParentModule().getName());
		args.add(webLogicForeignJMSConnectionFactory.getParentForeignServer().getName());
		args.add(webLogicForeignJMSConnectionFactory.getName());
		args.add(webLogicForeignJMSConnectionFactory.getLocalJNDIName());
		args.add(webLogicForeignJMSConnectionFactory.getRemoteJNDIName());
		return args.toArray(new String[args.size()]);
	}

}
