package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsForeignJmsServer;

/**
 * Creates a {@link WlsForeignJmsServer foreign JMS server}.
 */
@SuppressWarnings("serial")
public class CreateWlsForeignJmsServerStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-foreign-server.py";

	public CreateWlsForeignJmsServerStep(WlsDomain domain, WlsForeignJmsServer webLogicForeignServer) {
		super("Create Foreign Server " + webLogicForeignServer + " in domain " + domain, domain, SCRIPT_RESOURCE_PATH, getArgs(webLogicForeignServer));
	}

	private static String[] getArgs(WlsForeignJmsServer webLogicForeignServer) {
		List<String> args = new ArrayList<String>();
		args.add(webLogicForeignServer.getParentModule().getName());
		args.add(webLogicForeignServer.getName());
		args.add(webLogicForeignServer.getConnectionURL());
		args.add(webLogicForeignServer.getInitContextFactory());
		return args.toArray(new String[args.size()]);
	}

}
