package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsWorkManager;
import com.xebialabs.deployit.util.ExtendedStringUtils;

/**
 * Creates a {@link WlsWorkManager work manager}.
 */
@SuppressWarnings("serial")
public class CreateWlsWorkManagerStep extends SimpleWlstExecutingStep {

	public CreateWlsWorkManagerStep(WlsWorkManager workManager,  WlsDomain domain, Set<WlsCluster> clusters) {
		super("Create Work Manager " + workManager + " in domain " + domain, domain, STEP_RESOURCES_PATH + "create-work-manager.py", getArgs(
				workManager, domain, clusters));
	}

	private static String[] getArgs(WlsWorkManager workManager, WlsDomain domain, Set<WlsCluster> clusters) {
		List<String> args = new ArrayList<String>();
		args.add(workManager.getName());
		args.add(domain.getName());
		args.add(ExtendedStringUtils.join(clusters, WlsCluster.TOSTRING_FROM_NAME));
		args.add(workManager.getMaximumThreadsConstraint() != null ? workManager.getMaximumThreadsConstraint().getName() : null);
		return args.toArray(new String[args.size()]);
	}

}
