package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDataSource;

/**
 * Deletes a {@link WlsDataSource JDBC data source}.
 */
@SuppressWarnings("serial")
public class DestroyWlsDataSourceStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-datasource.py";

	public DestroyWlsDataSourceStep(WlsCluster cluster, WlsDataSource wlsDataSource) {
		super("Destroy datasource " + wlsDataSource + " on cluster " + cluster, cluster.getDomain(), SCRIPT_RESOURCE_PATH, getArgs(wlsDataSource));
	}

	private static String[] getArgs(WlsDataSource webLogicDatasource) {
		return new String[] { webLogicDatasource.getName() };
	}

}
