package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsForeignJmsDestination;

/**
 * Creates a {@link WlsForeignJmsDestination foreign JMS destination}.
 */
@SuppressWarnings("serial")
public class DestroyWlsForeignJmsDestinationStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-foreign-destination.py";

	public DestroyWlsForeignJmsDestinationStep(WlsDomain domain, WlsForeignJmsDestination foreignDestination) {
		super("Destroy Foreign Destination " + foreignDestination + " in domain " + domain, domain, SCRIPT_RESOURCE_PATH, getArgs(foreignDestination));
	}

	private static String[] getArgs(WlsForeignJmsDestination destination) {
		List<String> args = new ArrayList<String>();
		args.add(destination.getParentForeignServer().getParentModule().getName());
		args.add(destination.getParentForeignServer().getName());
		args.add(destination.getName());
		return args.toArray(new String[args.size()]);
	}

}
