package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.plugin.wls.WlsConventions;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsModule;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Deletes a {@link WlsJmsModule JMS module}.
 */
@SuppressWarnings("serial")
public class DestroyWlsJmsModuleStep extends SimpleWlstExecutingStep {

	public DestroyWlsJmsModuleStep(WlsCluster cluster, WlsJmsModule module) {
		super("Destroy JMS Module " + module + " on cluster " + cluster, cluster.getDomain(), STEP_RESOURCES_PATH + "destroy-jms-module.py", getArgs(module
				.getName(), cluster.getDomain(), cluster.getServers(), WlsConventions.getFilestorePath(cluster.getDomain())));
	}

	protected static String[] getArgs(String moduleName, WlsDomain domain, Set<WlsServer> servers, String filestorePath) {
		List<String> args = new ArrayList<String>();
		args.add(moduleName);
		String jmsServerPrefix = createJMServerPrefix(moduleName);

		List<WlsServer> sortedServers = WlsServer.toNameSortedList(servers);
		for (int i = 0; i < sortedServers.size(); i++) {
			WlsServer server = sortedServers.get(i);
			int jmsServerIndex = i + 1;
			String jmsServerName = jmsServerPrefix + "-JMSServer_" + jmsServerIndex;
			String jmsFileStoreName = jmsServerPrefix + "-JMSFileStore_" + jmsServerIndex;
			args.add(server.getName());
			args.add(jmsServerName);
			args.add(jmsFileStoreName);
			args.add(filestorePath);
			args.add(jmsServerName + "-subdeployment");

		}
		return args.toArray(new String[args.size()]);
	}

	protected static String createJMServerPrefix(String moduleName) {
		return StringUtils.remove(moduleName, "-JMSModule");
	}

}
