package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.wls.ci.WlsJmsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsModule;

/**
 * Deletes a {@link WlsJmsServer foreign JMS server}.
 */
@SuppressWarnings("serial")
public class DestroyWlsJmsServerStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-jms-server.py";

	public DestroyWlsJmsServerStep(WlsServer server, WlsJmsServer jmsServer, WlsJmsModule module) {
		super("Destroy JMS Servers " + jmsServer + "for Servers in Cluster " + server, server.getDomain(), SCRIPT_RESOURCE_PATH, getArgs(module, jmsServer));
	}

	private static String[] getArgs(WlsJmsModule module, WlsJmsServer jmsServer) {
		List<String> args = new ArrayList<String>();
		args.add(module.getName());
		args.add(jmsServer.getName());
		args.add(jmsServer.getName() + "-filestore");
		return args.toArray(new String[args.size()]);
	}

}
