package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Deletes a {@link WlsServer managed server}.
 */
@SuppressWarnings("serial")
public class DestroyWlsServerStep extends SimpleWlstExecutingStep {

	public static final String SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "destroy-server.py";

	public DestroyWlsServerStep(WlsServer server) {
		super("Destroy server " + server + " in domain " + server.getDomain() + " on host " + server.getHost(), server.getDomain(), SCRIPT_RESOURCE_PATH,
				server.getName());
	}

}
