package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Modifies a {@link WlsJmsQueue JMS queue}.
 */
@SuppressWarnings("serial")
public class ModifyWlsJmsQueueStep extends SimpleWlstExecutingStep {

	public ModifyWlsJmsQueueStep(WlsServer server, WlsJmsQueue oldQueue, WlsJmsQueue newQueue) {
		super("Modifying WebLogic Queue " + newQueue + " on server " + server + " in module " + oldQueue.getParentModule().getName(), server.getDomain(),
				STEP_RESOURCES_PATH + "configure-jms-queue.py", getArgs(server, oldQueue, newQueue));
	}

	private static String[] getArgs(WlsServer server, WlsJmsQueue oldQueue, WlsJmsQueue newQueue) {
		if (newQueue.getParentModule() == null) {
			throw new ResolutionException("Weblogic Queue " + newQueue + " is not associated with any Jms Module");
		}

		List<String> args = new ArrayList<String>();

		args.add(newQueue.getParentModule().getName());
		args.add(server.getName());
		args.add(newQueue.getName());
		args.add(newQueue.getJndiName());
		args.add(String.valueOf(newQueue.getRedeliveryDelayOverride()));
		args.add(String.valueOf(newQueue.getRedeliveryLimits()));
		args.add(newQueue.getExpirationPolicy().name());
		args.add(newQueue.getExpirationLoggingFormat());
		String errorQueueName = "";
		if (newQueue.getErrorQueue() != null) {
			errorQueueName = newQueue.getErrorQueue().getName();
		}
		args.add(errorQueueName);
		String oldErrorQueueName = "";
		if (oldQueue.getErrorQueue() != null) {
			oldErrorQueueName = oldQueue.getErrorQueue().getName();
		}
		args.add(oldErrorQueueName);

		return args.toArray(new String[args.size()]);
	}

}