package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Modifies a managed or admin {@link WlsServer server}.
 */
@SuppressWarnings("serial")
public class ModifyWlsServerStep extends SimpleWlstExecutingStep {

	private static final String CONFIGURE_SERVER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "configure-server.py";

	public ModifyWlsServerStep(WlsServer server) {
		super("Modify Server " + server.getHost() + " in domain " + server.getDomain() + " on host " + server.getHost(), server.getDomain(),
				CONFIGURE_SERVER_SCRIPT_RESOURCE_PATH, getArgs(server));
	}

	private static String[] getArgs(WlsServer server) {
		List<String> args = new ArrayList<String>();

		args.add(server.getName());
		args.add(server.getDomain().getWlHome());

		// generic arguments
		addConfigureServerArgument("arguments", server.getArguments(), args);

		// memory arguments
		addConfigureServerArgument("initheapsize", server.getInitHeapSize(), args);
		addConfigureServerArgument("maxheapsize", server.getMaxHeapSize(), args);

		// classpath arguments
		addConfigureServerArgument("bootclasspath", server.getBootClasspath(), args);
		addConfigureServerArgument("classpath", server.getClasspath(), args);

		// logging arguments
		addConfigureServerArgument("logfilename", server.getLogFileLocation(), args);
		addConfigureServerArgument("redirectstdouttoserverlog", String.valueOf(server.isEnableJVMLogRedirection()), args);

		// listen port
		addConfigureServerArgument("listenport", server.getPort(), args);

		return args.toArray(new String[args.size()]);

	}

	private static void addConfigureServerArgument(String propname, String propvalue, List<String> args) {
		if (StringUtils.isNotBlank(propvalue)) {
			args.add(propname);
			args.add(propvalue);
		}
	}

	private static void addConfigureServerArgument(String propname, int propvalue, List<String> args) {
		if (propvalue != 0) {
			args.add(propname);
			args.add(Integer.toString(propvalue));
		}
	}
}
