package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Restarts {@link WlsServer managed servers} that, according to the WebLogic console, need to be restarted.
 */
@SuppressWarnings("serial")
public class RestartServersThatRequireRestartStep extends SimpleWlstExecutingStep {

	public RestartServersThatRequireRestartStep(WlsDomain weblogicDomain) {
		super("Restarting server that require restart in WebLogic domain " + weblogicDomain, weblogicDomain, STEP_RESOURCES_PATH
				+ "restart-required-servers.py", weblogicDomain.getAdminServerName());
	}

}
