package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;

/**
 * Generic Step used to execute WLST commands on a {@link WlsDomain}.
 */
@SuppressWarnings("serial")
public class SimpleWlstExecutingStep extends WlsStepBase {

	/**
	 * The path of Jython script containing WLST commands.
	 */
	protected String scriptResourcePath;

	/**
	 * Arguments passed to Jython script.
	 */
	protected String[] scriptArgs;

	/**
	 * Creates a <tt>SimpleWlstExecutionStep</tt> with the specified parameters.
	 * 
	 * @param description
	 *            the description of the step
	 * @param domain
	 *            the domain on which to run this step
	 * @param scriptResourcePath
	 *            the resource path of the WLST script to execute
	 * @param theNewNumber
	 *            TODO
	 * @param scriptArgs
	 *            the parameters for the script. Automatically the username, password and the connect URL for the
	 */
	public SimpleWlstExecutingStep(String description, WlsDomain domain, String scriptResourcePath, String... scriptArgs) {
		super(domain);
		setDescription(description);

		this.scriptResourcePath = scriptResourcePath;
		this.scriptArgs = scriptArgs;
	}

	public boolean execute(StepExecutionContext ctx) {
		List<String> argsList = new ArrayList<String>();
		argsList.add(domain.getUsername());
		argsList.add(domain.getPassword());
		argsList.add(domain.getConnectUrl());
		argsList.addAll(Arrays.asList(scriptArgs));
		String[] args = argsList.toArray(new String[argsList.size()]);

		return executeWlstJythonScriptResource(ctx, scriptResourcePath, args) == 0;
	}

}
