import sys
import os
import time as ptime

sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)

moduleName = sys.argv.pop(0)
foreignServerName = sys.argv.pop(0)
foreignConnectionFactoryName = sys.argv.pop(0)
localJNDIName = sys.argv.pop(0)
remoteJNDIName = sys.argv.pop(0)

#==================================#
# Create ForeignConnectionFactory  #
#==================================#

def createForeignConnectionFactory(MODULENAME, FOREIGNSERVERNAME, FOREIGNCONNECTIONFACTORYNAME, LOCAL_JNDI, REMOTE_JNDI):
  """MODULENAME -- The JMS module name
  FOREIGNSERVERNAME -- The name of the Foreign JMS Server
  FOREIGNCONNECTIONFACTORYNAME -- Name of the foreign connection factory 
  LOCAL_JNDI -- The local JNDI name of the connection factory
  REMOTE_JNDI --  The remote JNDI name of the connection factory
  """
  log("Creating foreign connection factory : " + FOREIGNCONNECTIONFACTORYNAME + " on " + FOREIGNSERVERNAME)
  cd('/JMSSystemResources/'+ MODULENAME + '/JMSResource/'+ MODULENAME + '/ForeignServers/' + FOREIGNSERVERNAME)
  cmo.createForeignConnectionFactory(FOREIGNCONNECTIONFACTORYNAME)
  cd('/JMSSystemResources/'+ MODULENAME + '/JMSResource/'+ MODULENAME + '/ForeignServers/' + FOREIGNSERVERNAME + '/ForeignConnectionFactories/' + FOREIGNCONNECTIONFACTORYNAME)
  cmo.setLocalJNDIName(LOCAL_JNDI)
  cmo.setRemoteJNDIName(REMOTE_JNDI)
  return

#==============================#
# Logging method               #
#==============================#
def log(msg, level="info"):
    print ptime.strftime("%H:%M:%S", ptime.localtime()) + " <" + level + "> " + msg
    return
    
    
#==============================#
# Entry Point                  #
#==============================#
connect(user, password, url)
edit()
startEdit()
createForeignConnectionFactory(moduleName, foreignServerName, foreignConnectionFactoryName, localJNDIName, remoteJNDIName)
save()
disconnect('true')
exit('y')
