/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="A WebLogic Cluster, a member of WebLogic Domain. It can have WebLogicServers as it's members", expandable=true, category="middleware")
public class WlsCluster
extends BaseConfigurationItem {
    public static final Transformer TOSTRING_FROM_NAME = new Transformer(){

        public String transform(Object obj) {
            return ((WlsCluster)((Object)obj)).getName();
        }
    };
    @ConfigurationItemProperty(required=true, description="Name of the WebLogic Cluster", identifying=true)
    private String name = "";
    @ConfigurationItemProperty(required=true, description="The domain the WebLogic Cluster belongs to")
    private WlsDomain domain;
    @ConfigurationItemProperty(description="Servers in the WebLogic Cluster")
    private Set<WlsServer> servers = new HashSet<WlsServer>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WlsDomain getDomain() {
        return this.domain;
    }

    public void setDomain(WlsDomain domain) {
        this.domain = domain;
    }

    public Set<WlsServer> getServers() {
        return Collections.unmodifiableSet(this.servers);
    }

    public void setServers(Set<WlsServer> servers) {
        this.servers = servers;
    }

    public Host getHost() {
        return this.getDomain().getActiveHost();
    }
}

