import sys
import os
import time as ptime

ignore = sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)

modulename = sys.argv.pop(0)
basename = sys.argv.pop(0)
basejndiname = sys.argv.pop(0)
redeliverylimits = sys.argv.pop(0)

servernames = []
jmsservernames = []
module2serversnames = []
while len(sys.argv) >= 3:
    servernames.append(sys.argv.pop(0))
    jmsservernames.append(sys.argv.pop(0))
    module2serversnames.append(sys.argv.pop(0))

#====================#
# Queue collection   #
#====================#
def createQueueSet(modulename, basename, basejnidname, redeliverylimits=[]):
  log("Creating queues: " + basename)
  cd('/')
  print basename
  try:
      retrylimit=2
  except IndexError, reason:
      retrylimit=-1 
  
  queuenames = []
  malformednames  = []
  for i in range(0, len(jmsservernames)):
      queuename = basename+'_'+str(i+1)
      jndiname = basejndiname+'_'+str(i+1)
      errorname = basename+'_error_'+str(i+1)
      errorjndiname = basejndiname+'_'+str(i+1)
      malformedname = basename+'_malformed_'+str(i+1)
      malformedjndiname = basejndiname+'_malformed_'+str(i+1)
      queuenames = queuenames + [queuename]
      malformednames = malformednames + [malformedname]      
      createSimpleQueue( modulename, jmsservernames[i], module2serversnames[i], queuename, jndiname)
      createSimpleQueue( modulename, jmsservernames[i], module2serversnames[i], errorname, errorjndiname)
      createSimpleQueue( modulename, jmsservernames[i], module2serversnames[i], malformedname, malformedjndiname)
      setErrorDestination(modulename, queuename, errorname, retrylimit)
  createDistributedQueue(modulename, basename, basejndiname, queuenames)
  createDistributedQueue(modulename, basename+'_malformed', basejndiname+'_malformed', malformednames)
  return

#================#
# Simple Queue   #
#================#
def createSimpleQueue(modulename, jmsservername, module2serversname, queuename, jndiname) :
  """Create a simple single queue in a JMS server under a JMS Module.
  modulename -- The name of the JMSModule under which to create the queue
  jmsservername -- The name of the JMSServer which should deploy the queue
  queuename -- The name of the queue to create
  """
  log("Creating simple queue: "+queuename+" on "+jmsservername)
  cd('/JMSSystemResources/' + modulename + '/JMSResource/' + modulename)
  cmo.createQueue(queuename)
  cd('/JMSSystemResources/' + modulename + '/JMSResource/' + modulename + '/Queues/' + queuename)
  cmo.setJNDIName(jndiname)
  cmo.setSubDeploymentName(module2serversname)
  cd('/JMSSystemResources/' + modulename + '/SubDeployments/' + module2serversname)
  set('Targets',jarray.array([ObjectName('com.bea:Name=' + jmsservername + ',Type=JMSServer')], ObjectName))
  return

#====================#
# Distributed queue  #
#====================#
def createDistributedQueue(modulename, distqueuename, distqueuejndiname, queuenames):
  log("Create distributed queue "+distqueuename+ " for "+" ".join(queuenames) )
  cd('/JMSSystemResources/' + modulename + '/JMSResource/' + modulename)
  cmo.createDistributedQueue(distqueuename)
  cd('/JMSSystemResources/' + modulename + '/JMSResource/' + modulename + '/DistributedQueues/' + distqueuename)
  cmo.setJNDIName(distqueuejndiname)
  cmo.setLoadBalancingPolicy('Round-Robin')
  for queue in queuenames:
    cmo.createDistributedQueueMember(queue)
  return

#====================#
# Error destination  #
#====================#
def setErrorDestination(modulename, queuename, errorqueuename, retrylimit):
  log("Setting error destination from "+queuename+" to "+errorqueuename)
  cd('/JMSSystemResources/' + modulename + '/JMSResource/' + modulename + '/Queues/' + queuename + '/DeliveryFailureParams/' + queuename )
  cmo.setErrorDestination(getMBean('/JMSSystemResources/' + modulename + '/JMSResource/' + modulename + '/Queues/' + errorqueuename))
  cmo.setRedeliveryLimit(retrylimit)
  return

#==============================#
# Logging method               #
#==============================#
def log(msg, level="info"):
    print ptime.strftime("%H:%M:%S", ptime.localtime()) + " <" + level + "> " + msg
    return

connect(user, password, url)
edit()
startEdit()
redeliverylimitList = redeliverylimits.split(',')
createQueueSet(modulename, basename, basejndiname, redeliverylimitList)
save()
disconnect('true')
exit('y')
