/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.xebialabs.deployit.plugin.wls.ci.WlsServer;

/**
 * Modifies a managed or admin {@link WlsServer server}.
 */
@SuppressWarnings("serial")
public class ModifyWlsServerStep extends SimpleWlstExecutingStep {

	private static final String CONFIGURE_SERVER_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "configure-server.py";

	public ModifyWlsServerStep(WlsServer server) {
		super("Modify Server " + server.getHost() + " in domain " + server.getDomain() + " on host " + server.getHost(), server.getDomain(),
				CONFIGURE_SERVER_SCRIPT_RESOURCE_PATH, getArgs(server));
	}

	private static String[] getArgs(WlsServer server) {
		List<String> args = new ArrayList<String>();

		args.add(server.getName());
		args.add(server.getDomain().getWlHome());

		// generic arguments, including 
		addConfigureServerArgument("arguments", server.getArguments(), args);

		addConfigureServerArgument("classpath", server.getClasspath(), args);

		// logging arguments, incl. init- and maxheap size, bootclasspath
		addConfigureServerArgument("logfilename", server.getLogFileLocation(), args);
		addConfigureServerArgument("redirectstdouttoserverlog", String.valueOf(server.isEnableJVMLogRedirection()), args);

		// listen port
		addConfigureServerArgument("listenport", server.getPort(), args);

		return args.toArray(new String[args.size()]);

	}

	private static void addConfigureServerArgument(String propname, String propvalue, List<String> args) {
		if (StringUtils.isNotBlank(propvalue)) {
			args.add(propname);
			args.add(propvalue);
		}
	}

	private static void addConfigureServerArgument(String propname, int propvalue, List<String> args) {
		if (propvalue != 0) {
			args.add(propname);
			args.add(Integer.toString(propvalue));
		}
	}
}
