/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ChangeResolution;
import com.xebialabs.deployit.RunBook;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.mapper.EarToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.EarToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.EjbJarToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.EjbJarToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WarToWlsClusterMapper;
import com.xebialabs.deployit.plugin.wls.mapper.WarToWlsServerMapper;
import com.xebialabs.deployit.plugin.wls.step.ActivatePendingChangesStep;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsServerStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsServerStep;
import com.xebialabs.deployit.plugin.wls.step.ModifyWlsServerStep;
import com.xebialabs.deployit.plugin.wls.step.StartStopStepFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WlsServerRunBook
implements RunBook {
    public Collection<ChangeResolution> resolve(ChangePlan changePlan) {
        ArrayList<ChangeResolution> changeResolutions = new ArrayList<ChangeResolution>();
        for (Change change : changePlan.getChanges()) {
            if (!change.getConfigurationItemClass().equals(WlsServer.class)) continue;
            if (change.isDeletion()) {
                changeResolutions.add(new ChangeResolution(change, this.getDeletionSteps((Change<WlsServer>)change)));
            }
            if (change.isAddition()) {
                changeResolutions.add(new ChangeResolution(change, this.getCreationSteps((Change<WlsServer>)change)));
            }
            if (!change.isModification() || this.modificationIsHandledByWlsDeploymentRunBook(changePlan, (Change<WlsServer>)change)) continue;
            changeResolutions.add(new ChangeResolution(change, this.getModificationSteps((Change<WlsServer>)change)));
        }
        return changeResolutions;
    }

    private boolean modificationIsHandledByWlsDeploymentRunBook(ChangePlan changePlan, Change<WlsServer> serverChange) {
        for (Change deploymentChange : this.getChangesForCiType(changePlan, Deployment.class)) {
            if (!deploymentChange.isModification()) continue;
            EarToWlsServerMapper earToServerMapper = new EarToWlsServerMapper((Change<Deployment>)deploymentChange);
            EjbJarToWlsServerMapper ejbToServerMapper = new EjbJarToWlsServerMapper((Change<Deployment>)deploymentChange);
            WarToWlsServerMapper warToServerMapper = new WarToWlsServerMapper((Change<Deployment>)deploymentChange);
            EarToWlsClusterMapper earToWlsClusterMapper = new EarToWlsClusterMapper((Change<Deployment>)deploymentChange);
            WarToWlsClusterMapper warToWlsClusterMapper = new WarToWlsClusterMapper((Change<Deployment>)deploymentChange);
            EjbJarToWlsClusterMapper ejbToWlsClusterMapper = new EjbJarToWlsClusterMapper((Change<Deployment>)deploymentChange);
            HashSet<WlsServer> oldTargetServers = new HashSet<WlsServer>();
            oldTargetServers.addAll(earToServerMapper.getOldTargets());
            oldTargetServers.addAll(warToServerMapper.getOldTargets());
            oldTargetServers.addAll(ejbToServerMapper.getOldTargets());
            HashSet oldTargetClusters = new HashSet();
            oldTargetClusters.addAll(earToWlsClusterMapper.getOldTargets());
            oldTargetClusters.addAll(warToWlsClusterMapper.getOldTargets());
            oldTargetClusters.addAll(ejbToWlsClusterMapper.getOldTargets());
            for (WlsCluster cluster : oldTargetClusters) {
                oldTargetServers.addAll(cluster.getServers());
            }
            HashSet<WlsServer> newTargetServers = new HashSet<WlsServer>();
            newTargetServers.addAll(earToServerMapper.getNewTargets());
            newTargetServers.addAll(warToServerMapper.getNewTargets());
            newTargetServers.addAll(ejbToServerMapper.getNewTargets());
            HashSet newTargetClusters = new HashSet();
            newTargetClusters.addAll(earToWlsClusterMapper.getNewTargets());
            newTargetClusters.addAll(warToWlsClusterMapper.getNewTargets());
            newTargetClusters.addAll(ejbToWlsClusterMapper.getNewTargets());
            for (WlsCluster cluster : newTargetClusters) {
                newTargetServers.addAll(cluster.getServers());
            }
            if (!oldTargetServers.contains(serverChange.getOldRevision()) || !newTargetServers.contains(serverChange.getNewRevision())) continue;
            return true;
        }
        return false;
    }

    private Set<Change> getChangesForCiType(ChangePlan cp, Class<? extends Serializable> changeTypeClass) {
        HashSet<Change> changesOfType = new HashSet<Change>();
        for (Change change : cp.getChanges()) {
            if (!changeTypeClass.equals(change.getConfigurationItemClass())) continue;
            changesOfType.add(change);
        }
        return changesOfType;
    }

    public List<Step> getCreationSteps(Change<WlsServer> change) {
        WlsServer server = (WlsServer)((Object)change.getNewRevision());
        ArrayList<Step> allSteps = new ArrayList<Step>();
        allSteps.add(new CreateWlsServerStep(server));
        allSteps.add(new ModifyWlsServerStep(server));
        allSteps.add(new ActivatePendingChangesStep(server.getDomain()));
        allSteps.add(new StartStopStepFactory().getStartStep(server));
        return allSteps;
    }

    public List<Step> getDeletionSteps(Change<WlsServer> change) {
        WlsServer server = (WlsServer)((Object)change.getOldRevision());
        ArrayList<Step> allSteps = new ArrayList<Step>();
        allSteps.add(new StartStopStepFactory().getStopStep(server));
        allSteps.add(new DestroyWlsServerStep(server));
        allSteps.add(new ActivatePendingChangesStep(server.getDomain()));
        return allSteps;
    }

    public List<Step> getModificationSteps(Change<WlsServer> change) {
        WlsServer server = (WlsServer)((Object)change.getNewRevision());
        ArrayList<Step> allSteps = new ArrayList<Step>();
        StartStopStepFactory factory = new StartStopStepFactory();
        allSteps.add(factory.getStopStep(server));
        allSteps.add(new ModifyWlsServerStep(server));
        allSteps.add(new ActivatePendingChangesStep(server.getDomain()));
        allSteps.add(factory.getStartStep(server));
        return allSteps;
    }
}

