/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.apache.httpd.step.RestartApacheHttpdServerStep;
import com.xebialabs.deployit.plugin.wls.ci.ApacheHttpdWlsPluginConfiguration;
import com.xebialabs.deployit.plugin.wls.ci.ApacheHttpdWlsPluginConfigurationMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.step.CreateApacheHttpdWlsPluginConfigFileStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyApacheHttpdWlsPluginConfigFileStep;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheHttpdWlsPluginConfigurationToApacheHttpdServerMapper
extends StepGeneratingMapper<ApacheHttpdWlsPluginConfiguration, ApacheHttpdWlsPluginConfigurationMapping, ApacheHttpdServer> {
    public ApacheHttpdWlsPluginConfigurationToApacheHttpdServerMapper(Change<Deployment> change) {
        super(change);
    }

    protected void generateAdditionStepsForAddedMapping(ApacheHttpdWlsPluginConfiguration newSource, ApacheHttpdWlsPluginConfigurationMapping newMapping, ApacheHttpdServer newTarget, List<Step> steps) {
        Set<WlsCluster> exposedClusters = newMapping.getClusters();
        if (exposedClusters.size() != 1) {
            throw new ResolutionException("Can only expose exactly one WebLogic cluster, found " + exposedClusters.size());
        }
        WlsCluster singleExposedCluster = (WlsCluster)((Object)CollectionUtils.get(exposedClusters, (int)0));
        steps.add(new CreateApacheHttpdWlsPluginConfigFileStep(newTarget, newSource, singleExposedCluster, newMapping.getVirtualHost()));
        steps.add((Step)new RestartApacheHttpdServerStep(newTarget));
    }

    protected void generateDeletionStepsForModifiedMapping(ApacheHttpdWlsPluginConfiguration oldSource, ApacheHttpdWlsPluginConfigurationMapping oldMapping, ApacheHttpdServer oldTarget, List<Step> steps) {
    }

    protected void generateDeletionStepsForDeletedMapping(ApacheHttpdWlsPluginConfiguration oldSource, ApacheHttpdWlsPluginConfigurationMapping oldMapping, ApacheHttpdServer oldTarget, List<Step> steps) {
        Set<WlsCluster> exposedClusters = oldMapping.getClusters();
        if (exposedClusters.size() != 1) {
            throw new ResolutionException("Can only expose exactly one WebLogic cluster");
        }
        WlsCluster singleExposedCluster = (WlsCluster)((Object)CollectionUtils.get(exposedClusters, (int)0));
        steps.add(new DestroyApacheHttpdWlsPluginConfigFileStep(oldTarget, oldSource, singleExposedCluster, oldMapping.getVirtualHost()));
        steps.add((Step)new RestartApacheHttpdServerStep(oldTarget));
    }

    public void setDefaults(Deployment d, ApacheHttpdWlsPluginConfigurationMapping m) {
        m.setVirtualHost(d.getVhostDefinition());
        m.setClusters(d.getTarget().getMembersOfType(WlsCluster.class));
    }
}

