/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsServerResourceMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.mapper.JmsMapperUtils;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsJmsServerFilestorePathStep;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsJmsServerStep;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsSubdeploymentStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsJmsServerStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsSubdeploymentStep;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WlsJmsServerToWlsServerMapper
extends MappingAgnosticStepGeneratingMapper<WlsJmsServer, WlsServerResourceMapping, WlsServer> {
    private final Map<WlsServer, WlsCluster> oldServerClusters;
    private final Map<WlsServer, WlsCluster> newServerClusters;

    public WlsJmsServerToWlsServerMapper(Change<Deployment> change, Map<WlsServer, WlsCluster> oldServerClusters, Map<WlsServer, WlsCluster> newServerClusters) {
        super(change);
        this.oldServerClusters = oldServerClusters;
        this.newServerClusters = newServerClusters;
    }

    protected void generateAdditionStepsForAddedMapping(WlsJmsServer jmsServer, WlsServer server, List<Step> steps) {
        if (server.isRunningVersion8()) {
            return;
        }
        steps.add((Step)new CreateWlsJmsServerFilestorePathStep(server, jmsServer));
        steps.add(new CreateWlsJmsServerStep(server, jmsServer));
        steps.add(new CreateWlsSubdeploymentStep(server.getDomain(), JmsMapperUtils.getJmsModuleName((Change<Deployment>)this.change, WlsJmsServerToWlsServerMapper.getClusterIfApplicable(server, this.newServerClusters)), jmsServer));
    }

    private static WlsTarget getClusterIfApplicable(WlsServer server, Map<WlsServer, WlsCluster> serverClusters) {
        return (WlsTarget)((Object)ObjectUtils.defaultIfNull((Object)((Object)serverClusters.get((Object)server)), (Object)((Object)server)));
    }

    protected void generateDeletionStepsForDeletedMapping(WlsJmsServer jmsServer, WlsServer server, List<Step> steps) {
        if (server.isRunningVersion8()) {
            return;
        }
        steps.add(new DestroyWlsSubdeploymentStep(server.getDomain(), JmsMapperUtils.getJmsModuleName((Change<Deployment>)this.change, WlsJmsServerToWlsServerMapper.getClusterIfApplicable(server, this.oldServerClusters)), jmsServer));
        steps.add(new DestroyWlsJmsServerStep(server.getDomain(), jmsServer));
    }
}

