package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;

import java.util.Map;

/**
 * Deploys applications on a {@link com.xebialabs.deployit.plugin.wls.ci.WlsCluster cluster} V8 or {@link com.xebialabs.deployit.plugin.wls.ci.WlsServer managed server} V8 using nostage mode.
 */
@SuppressWarnings("serial")
public class Wls8DeployNoStageArtifactStep extends Wls8WeblogicDeployerStepBase implements Step {

	private String extension;
	private String targetName;
	private String applicationName;
	private String remoteArchivePath;

	public Wls8DeployNoStageArtifactStep(WlsTarget target, NamedDeployableArtifact artifact, String remoteArchivePath) {
		super(target.getDomain());
		this.targetName = target.getName();
		this.applicationName = artifact.getName();
		this.extension = findOutExtension(artifact);
		this.remoteArchivePath = remoteArchivePath;
		setDescription("Deploy  " + artifact + " on " + target + " nostage mode using " + remoteArchivePath);
	}


	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = domain.connectToAdminHost();
		try {
			Map<String, String> velocityContext = Maps.newHashMap();
			velocityContext.put("username", domain.getUsername());
			velocityContext.put("password", domain.getPassword());
			velocityContext.put("adminurl", domain.getConnectUrl());
			velocityContext.put("wlHome", domain.getWlHome());
			velocityContext.put("uploadedApplication", remoteArchivePath);
			velocityContext.put("target", targetName);
			velocityContext.put("name", applicationName);
			velocityContext.put("deployerAction", "-upload -nostage  -deploy " + remoteArchivePath);

			return executeWeblogicDeployerScript(ctx, rhs, velocityContext) == 0;
		} finally {
			rhs.close();
		}
	}
}
