/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsSharedLibraryJar;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;

/**
 * Undeploys a deployed {@link NamedDeployableArtifact application}.
 */
@SuppressWarnings("serial")
public class WlsUndeployArtifactStep extends SimpleWlstExecutingStep {

	private static final String SCRIPT_NAME = STEP_RESOURCES_PATH + "undeploy-application.py";

	public WlsUndeployArtifactStep(WlsServer server, Ear application) {
		super("Undeploy EAR " + application + " from Domain " + server.getDomain() + " and Server " + server, server.getDomain(), SCRIPT_NAME,
				server.getName(), application.getName());
	}

	public WlsUndeployArtifactStep(WlsCluster cluster, Ear application) {
		super("Undeploy EAR " + application + " from Domain " + cluster.getDomain() + " and Cluster " + cluster, cluster.getDomain(), SCRIPT_NAME, cluster
				.getName(), application.getName());
	}

	public WlsUndeployArtifactStep(WlsServer server, War application) {
		super("Undeploy WAR " + application + " from Domain " + server.getDomain() + " and Server " + server, server.getDomain(), SCRIPT_NAME,
				server.getName(), application.getName());
	}

	public WlsUndeployArtifactStep(WlsCluster cluster, War application) {
		super("Undeploy WAR " + application + " from Domain " + cluster.getDomain() + " and Cluster " + cluster, cluster.getDomain(), SCRIPT_NAME, cluster
				.getName(), application.getName());
	}

	public WlsUndeployArtifactStep(WlsServer server, EjbJar application) {
		super("Undeploy EJB " + application + " from Domain " + server.getDomain() + " and Server " + server, server.getDomain(), SCRIPT_NAME,
				server.getName(), application.getName());
	}

	public WlsUndeployArtifactStep(WlsCluster cluster, EjbJar application) {
		super("Undeploy EJB " + application + " from Domain " + cluster.getDomain() + " and Cluster " + cluster, cluster.getDomain(), SCRIPT_NAME, cluster
				.getName(), application.getName());
	}

	public WlsUndeployArtifactStep(WlsCluster cluster, WlsSharedLibraryJar library) {
		super("Undeploy Jar Library " + library + " from Domain " + cluster.getDomain() + " and Cluster " + cluster, cluster.getDomain(), SCRIPT_NAME, cluster
				.getName(), library.getName());
	}

	public WlsUndeployArtifactStep(WlsServer server, WlsSharedLibraryJar library) {
		super("Undeploy Jar Library " + library + " from Domain " + server.getDomain() + " and Cluster " + server, server.getDomain(), SCRIPT_NAME, server
				.getName(), library.getName());
	}

	public WlsUndeployArtifactStep(WlsTarget target, NamedDeployableArtifact artifact) {
		super("Undeploy " + artifact + " from Domain " + target.getDomain() + " and " + target, target.getDomain(), SCRIPT_NAME, target
				.getName(), artifact.getName());
	}
}
