/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.mapping.EjbJarMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsArtifactMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsDeploymentPlan;
import com.xebialabs.deployit.plugin.wls.ci.WlsDeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.ci.WlsStageMode;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="A mapping of an EjbJar to a WebLogic target")
public class WlsEjbJarMapping
extends EjbJarMapping<WlsTarget>
implements WlsArtifactMapping {
    @ConfigurationItemProperty(required=false)
    private WlsDeploymentStrategy deploymentStrategy = WlsDeploymentStrategy.CLASSIC;
    @ConfigurationItemProperty(required=false, description="Deployment staging mode (default is stage)")
    private WlsStageMode stageMode;
    @ConfigurationItemProperty(required=false, description="Remote directory where the archives (ear,jar,war) are copied before deploying")
    protected String stagingDirectory;
    @ConfigurationItemProperty(required=false)
    private WlsDeploymentPlan deploymentPlan;
    @ConfigurationItemProperty(required=false)
    protected String deploymentPlanStagingDirectory;

    public WlsEjbJarMapping() {
    }

    public WlsEjbJarMapping(EjbJar source, WlsTarget target) {
        this(source, target, WlsStageMode.Stage, "");
    }

    public WlsEjbJarMapping(EjbJar source, WlsTarget target, WlsStageMode stageMode, String stagingDirectory) {
        super(source, (Serializable)((Object)target));
        this.stageMode = stageMode;
        this.stagingDirectory = stagingDirectory;
    }

    @Override
    public WlsDeploymentStrategy getDeploymentStrategy() {
        return this.deploymentStrategy;
    }

    @Override
    public void setDeploymentStrategy(WlsDeploymentStrategy strategy) {
        this.deploymentStrategy = strategy;
    }

    @Override
    public WlsStageMode getStageMode() {
        return this.stageMode == null ? WlsStageMode.Stage : this.stageMode;
    }

    public void setStageMode(WlsStageMode stageMode) {
        this.stageMode = stageMode;
    }

    @Override
    public String getStagingDirectory() {
        return this.stagingDirectory;
    }

    @Override
    public WlsDeploymentPlan getDeploymentPlan() {
        return this.deploymentPlan;
    }

    @Override
    public String getDeploymentPlanStagingDirectory() {
        return this.deploymentPlanStagingDirectory;
    }

    public void setStagingDirectory(String stagingDirectory) {
        this.stagingDirectory = stagingDirectory;
    }

    public void setDeploymentPlan(WlsDeploymentPlan deploymentPlan) {
        this.deploymentPlan = deploymentPlan;
    }

    public void setDeploymentPlanStagingDirectory(String deploymentPlanStagingDirectory) {
        this.deploymentPlanStagingDirectory = deploymentPlanStagingDirectory;
    }
}

