/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.CommandExecution;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.common.ErrorStreamToCallbackHandler;
import com.xebialabs.deployit.hostsession.common.OutputStreamToCallbackHandler;
import java.io.PrintWriter;

@ConfigurationItem
public class WmqQueueManager
extends BaseConfigurationItem {
    @ConfigurationItemProperty(identifying=true)
    private Host host;
    @ConfigurationItemProperty(required=true, identifying=true)
    private String name;

    public WmqQueueManager() {
    }

    public WmqQueueManager(String label, Host host, String name) {
        this.label = label;
        this.host = host;
        this.name = name;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeRunMqscCommand(String line, CommandExecutionCallbackHandler handler) {
        HostSession s = this.getHost().getHostSession();
        try {
            CommandExecution runMqscCommand = s.startExecute(new String[]{"runmqsc", this.getName()});
            Thread outputStreamForwardingThread = new Thread((Runnable)new OutputStreamToCallbackHandler(runMqscCommand.getStdout(), handler));
            outputStreamForwardingThread.start();
            Thread errorStreamForwardingThread = new Thread((Runnable)new ErrorStreamToCallbackHandler(runMqscCommand.getStderr(), handler));
            errorStreamForwardingThread.start();
            PrintWriter stdin = new PrintWriter(runMqscCommand.getStdin());
            try {
                stdin.println(line);
                stdin.println("END");
            }
            finally {
                stdin.close();
            }
            int n = runMqscCommand.waitFor();
            return n;
        }
        finally {
            s.close();
        }
    }
}

