/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.plugin.wmq.ci.WmqLocalQueue;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;

class CreateOrModifyWmqLocalQueueStep
implements Step {
    private WmqQueueManager queueManager;
    private WmqLocalQueue queue;
    private boolean modify;

    public CreateOrModifyWmqLocalQueueStep(WmqQueueManager queueManager, WmqLocalQueue queue, boolean modify) {
        this.queueManager = queueManager;
        this.queue = queue;
        this.modify = modify;
    }

    public boolean execute(StepExecutionContext ctx) {
        StepExecutionContextCallbackHandler handler = new StepExecutionContextCallbackHandler(ctx);
        StringBuffer defineCommand = new StringBuffer();
        defineCommand.append(this.modify ? "ALTER" : "DEFINE");
        defineCommand.append(" QLOCAL(");
        defineCommand.append(this.queue.getName());
        defineCommand.append(")");
        if (this.queue.getMaxDepth() > 0) {
            defineCommand.append(" MAXDEPTH(");
            defineCommand.append(this.queue.getMaxDepth());
            defineCommand.append(")");
        }
        defineCommand.append(" DEFPSIST(");
        defineCommand.append(this.queue.isPersistent() ? "YES" : "NO");
        defineCommand.append(")");
        int exitValue = this.queueManager.executeRunMqscCommand(defineCommand.toString(), (CommandExecutionCallbackHandler)handler);
        return exitValue == 0;
    }

    public String getDescription() {
        return (this.modify ? "Modify" : "Create") + " queue " + (Object)((Object)this.queue) + " on queue manager " + (Object)((Object)this.queueManager);
    }
}

