/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqReceiverChannel;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPutAuthority;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonpersistentMessageSpeed;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLClientAuthentication;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

public class CreateWmqReceiverChannelStep
extends BaseWmqStep {
    public WmqReceiverChannel wmqReceiverChannel;

    public CreateWmqReceiverChannelStep(WmqReceiverChannel wmqReceiverChannel, WmqQueueManager wmqQmanager) {
        this.wmqQmanager = wmqQmanager;
        this.wmqReceiverChannel = wmqReceiverChannel;
    }

    protected void init() {
        this.mqCommand = 23;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        int[] list;
        pcfCmd.addParameter(3501, this.wmqReceiverChannel.getChannelName());
        pcfCmd.addParameter(1511, 3);
        if (StringUtils.isNotBlank(this.wmqReceiverChannel.getDescription())) {
            pcfCmd.addParameter(3502, this.wmqReceiverChannel.getDescription());
        }
        if (WmqTransmissionProtocolTypes.LU6 == this.wmqReceiverChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 1);
        } else if (WmqTransmissionProtocolTypes.NET_BIOS == this.wmqReceiverChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 3);
        } else if (WmqTransmissionProtocolTypes.SPX == this.wmqReceiverChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 4);
        } else {
            pcfCmd.addParameter(1501, 2);
        }
        int[] messageCompressionList = new int[1];
        if (WmqHeaderCompression.SYSTEM == this.wmqReceiverChannel.getHeaderCompression()) {
            list = new int[]{8};
            pcfCmd.addParameter(1575, list);
        } else {
            list = new int[]{0};
            pcfCmd.addParameter(1575, list);
        }
        pcfCmd.addParameter(1563, this.wmqReceiverChannel.getHeartBeatInterval());
        if (this.wmqReceiverChannel.getKeepAliveInterval() > -1 && this.wmqReceiverChannel.getKeepAliveInterval() <= 99999) {
            pcfCmd.addParameter(1566, this.wmqReceiverChannel.getKeepAliveInterval());
        }
        pcfCmd.addParameter(1510, this.wmqReceiverChannel.getMaximumMessageLength());
        if (this.wmqReceiverChannel.getSequenceNumberWrap() < 100) {
            pcfCmd.addParameter(1509, 999999999);
        } else if (this.wmqReceiverChannel.getSequenceNumberWrap() != 0) {
            pcfCmd.addParameter(1509, this.wmqReceiverChannel.getSequenceNumberWrap());
        }
        if (WmqChannelMessageCompression.ANY == this.wmqReceiverChannel.getMessageCompression()) {
            messageCompressionList[0] = 0xFFFFFFF;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else if (WmqChannelMessageCompression.RLE == this.wmqReceiverChannel.getMessageCompression()) {
            messageCompressionList[0] = 1;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else if (WmqChannelMessageCompression.ZLIBFAST == this.wmqReceiverChannel.getMessageCompression()) {
            messageCompressionList[0] = 2;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else if (WmqChannelMessageCompression.ZLIBHIGH == this.wmqReceiverChannel.getMessageCompression()) {
            messageCompressionList[0] = 4;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else {
            messageCompressionList[0] = 0;
            pcfCmd.addParameter(1576, messageCompressionList);
        }
        if (WmqNonpersistentMessageSpeed.NORMAL == this.wmqReceiverChannel.getNonPersistentMessageSpeed()) {
            pcfCmd.addParameter(1562, 1);
        } else {
            pcfCmd.addParameter(1562, 2);
        }
        pcfCmd.addParameter(1502, this.wmqReceiverChannel.getBatchSize());
        if (WmqChannelPutAuthority.CONTEXT == this.wmqReceiverChannel.getPutAuthority()) {
            pcfCmd.addParameter(1508, 2);
        } else {
            pcfCmd.addParameter(1508, 1);
        }
        if (StringUtils.isNotBlank(this.wmqReceiverChannel.getMcaUserID())) {
            pcfCmd.addParameter(3527, this.wmqReceiverChannel.getMcaUserID());
        }
        if (StringUtils.isNotBlank(this.wmqReceiverChannel.getSendExit())) {
            String[] sendExitList = StringUtils.split(this.wmqReceiverChannel.getSendExit(), ",");
            pcfCmd.addParameter(3510, sendExitList);
        }
        if (StringUtils.isNotBlank(this.wmqReceiverChannel.getSendExitUserData())) {
            String[] sendExitUserDataList = StringUtils.split(this.wmqReceiverChannel.getSendExitUserData(), ",");
            pcfCmd.addParameter(3515, sendExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqReceiverChannel.getReceiveExit())) {
            String[] receiveExitList = StringUtils.split(this.wmqReceiverChannel.getReceiveExit(), ",");
            pcfCmd.addParameter(3511, receiveExitList);
        }
        if (StringUtils.isNotBlank(this.wmqReceiverChannel.getReceiveExitUserData())) {
            String[] receiveExitUserDataList = StringUtils.split(this.wmqReceiverChannel.getReceiveExitUserData(), ",");
            pcfCmd.addParameter(3516, receiveExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqReceiverChannel.getSecurityExit())) {
            pcfCmd.addParameter(3508, this.wmqReceiverChannel.getSecurityExit());
        }
        if (StringUtils.isNotBlank(this.wmqReceiverChannel.getSecurityExitUserData())) {
            pcfCmd.addParameter(3513, this.wmqReceiverChannel.getSecurityExitUserData());
        }
        if (StringUtils.isNotBlank(this.wmqReceiverChannel.getMessageExitName())) {
            String[] messageExitList = StringUtils.split(this.wmqReceiverChannel.getMessageExitName(), ",");
            pcfCmd.addParameter(3509, messageExitList);
        }
        if (StringUtils.isNotBlank(this.wmqReceiverChannel.getMessageExitUserData())) {
            String[] messageExitUserList = StringUtils.split(this.wmqReceiverChannel.getMessageExitUserData(), ",");
            pcfCmd.addParameter(3514, messageExitUserList);
        }
        pcfCmd.addParameter(1544, this.wmqReceiverChannel.getMessageRetryCount());
        pcfCmd.addParameter(1545, this.wmqReceiverChannel.getMessageRetryInterval());
        if (StringUtils.isNotBlank(this.wmqReceiverChannel.getMessageRetryExitname())) {
            pcfCmd.addParameter(3534, this.wmqReceiverChannel.getMessageRetryExitname());
        }
        if (StringUtils.isNotBlank(this.wmqReceiverChannel.getMessageRetryExitUserData())) {
            pcfCmd.addParameter(3535, this.wmqReceiverChannel.getMessageRetryExitUserData());
        }
        if (WmqChannelMonitoring.HIGH == this.wmqReceiverChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 65);
        } else if (WmqChannelMonitoring.LOW == this.wmqReceiverChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 17);
        } else if (WmqChannelMonitoring.MEDIUM == this.wmqReceiverChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 33);
        } else if (WmqChannelMonitoring.OFF == this.wmqReceiverChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 0);
        } else {
            pcfCmd.addParameter(122, -3);
        }
        if (WmqChannelStatisticTypes.HIGH == this.wmqReceiverChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 65);
        } else if (WmqChannelStatisticTypes.LOW == this.wmqReceiverChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 17);
        } else if (WmqChannelStatisticTypes.MEDIUM == this.wmqReceiverChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 33);
        } else if (WmqChannelStatisticTypes.OFF == this.wmqReceiverChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 0);
        } else {
            pcfCmd.addParameter(129, -3);
        }
        if (this.wmqReceiverChannel.getSslCipherSpecification() != null) {
            pcfCmd.addParameter(3544, this.wmqReceiverChannel.getSslCipherSpecification().toString());
        }
        if (WmqSSLClientAuthentication.OPTIONAL == this.wmqReceiverChannel.getSslClientAuth()) {
            pcfCmd.addParameter(1568, 1);
        } else {
            pcfCmd.addParameter(1568, 0);
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating ReceiverChannel \"" + this.wmqReceiverChannel.getChannelName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating ReceiverChannel Step";
    }

    protected String getSuccessMessage() {
        return "The ReceiverChannel \"" + this.wmqReceiverChannel.getChannelName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

