/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.utils.RegexUtils;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class RetrieveWmqListenerNamesStep
implements Step {
    private WmqQueueManager wmqQueueManager;

    public RetrieveWmqListenerNamesStep(WmqQueueManager wmqQueueManager) {
        this.wmqQueueManager = wmqQueueManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession hostSession = this.wmqQueueManager.getHostName().getHostSession();
        ArrayList<String> listenerNames = new ArrayList<String>();
        try {
            CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
            ArrayList<String> cmd = new ArrayList<String>();
            if (this.wmqQueueManager.getHostName().getOperatingSystemFamily() == OperatingSystemFamily.WINDOWS) {
                cmd.add("cmd");
                cmd.add("/c");
            }
            cmd.add("echo");
            cmd.add("dis");
            cmd.add("lstr(*)");
            cmd.add("port");
            cmd.add("trptype(tcp)");
            cmd.add("|");
            cmd.add("runmqsc");
            cmd.add(this.wmqQueueManager.getQueueManagerName());
            Object[] cmdArray = cmd.toArray(new String[cmd.size()]);
            int res = hostSession.execute((CommandExecutionCallbackHandler)capturedOutput, (String[])cmdArray);
            if (res != 0) {
                ctx.logError("Non-zero exitcode from " + StringUtils.join((Object[])cmdArray, (String)" ") + ": " + res);
                boolean bl = false;
                return bl;
            }
            for (String eachLine : capturedOutput.getOutputLines()) {
                String[] matches;
                if (!eachLine.contains("PORT") || (matches = RegexUtils.regexMatch(eachLine, "[\\s\\S]*\\((\\S+)\\)\\s+PORT\\((\\d+)\\)")) == null || matches.length != 2) continue;
                listenerNames.add(matches[0]);
            }
        }
        finally {
            hostSession.close();
        }
        if (listenerNames.size() > 0) {
            ctx.setAttribute(this.wmqQueueManager.getQueueManagerName() + ":LISTENER", listenerNames);
            ctx.logOutput("Available Tcp Listener Names for QueueManager \"" + this.wmqQueueManager.getQueueManagerName() + "\"" + listenerNames);
            return true;
        }
        ctx.logError("Listener for  Queue Manager \"" + this.wmqQueueManager.getQueueManagerName() + "\" are not available");
        return false;
    }

    public String getDescription() {
        if (this.wmqQueueManager.getQueueManagerName() != null) {
            return "Retrieving the TCPListeners for QueueManager \"" + this.wmqQueueManager.getQueueManagerName() + "\"";
        }
        return "Retrieve WmqListener Names Step";
    }
}

