/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "The MQServerChannel class represents an individual server channel on a particular queue manager. Enumerating an object of this class results in an empty list.")
public class WmqServerChannel extends WmqBaseServerChannel {

	@ConfigurationItemProperty(required = false, label = "MQ Version", description = "Specify type of MQ Version", size = Size.LARGE)
	private WmqVersion version;

	@ConfigurationItemProperty(label = "Property control", category = "Extended")
	private WmqChannelPropertyControl propertyControl;

	public WmqChannelPropertyControl getPropertyControl() {
		return propertyControl;
	}

	public void setPropertyControl(WmqChannelPropertyControl propertyControl) {
		this.propertyControl = propertyControl;
	}

	public WmqVersion getVersion() {
		return version;
	}

}
