/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqTopic;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqWildcardOperation;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDurableSubscriptions;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonPersistentMessageDelivery;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPersistentMessageDelivery;
import com.xebialabs.deployit.plugin.wmq.enums.WmqProxySubscriptionBehavior;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPublicationScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSubscriptionScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTopicDefaultPersistence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTopicDefaultPutResponseType;

/**
 * Modifies the properties of a {@link WmqTopic} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class ModifyWmqTopicStep extends CreateWmqTopicStep {

	@Override
	protected void init() {
		if (wmqQmanager.getVersion() == WmqVersion.WMQ_60) {

			throw new ResolutionException("Topic is not supported in MQV6");
		}
		this.mqCommand = MQConstants.MQCMD_CHANGE_TOPIC;

	}

	public ModifyWmqTopicStep(WmqTopic wmqTopic, WmqQueueManager wmqQManager) {
		super(wmqTopic, wmqQManager);

	}

	@Override
	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// topic-name - mandatory
		pcfCmd.addParameter(MQConstants.MQCA_TOPIC_NAME, wmqTopic.getTopicName());

		// Topic description - optional.
		pcfCmd.addParameter(MQConstants.MQCA_TOPIC_DESC, wmqTopic.getDescription());

		// DurablesubScriptions -optional
		if (WmqDurableSubscriptions.AS_PARENT == wmqTopic.getDurablesubScriptions()) {
			pcfCmd.addParameter(MQConstants.MQIA_DURABLE_SUB, MQConstants.MQSUB_DURABLE_AS_PARENT);

		} else if (WmqDurableSubscriptions.ALLOWED == wmqTopic.getDurablesubScriptions()) {

			pcfCmd.addParameter(MQConstants.MQIA_DURABLE_SUB, MQConstants.MQSUB_DURABLE_ALLOWED);
		} else if (WmqDurableSubscriptions.INHIBITED == (wmqTopic.getDurablesubScriptions())) {

			pcfCmd.addParameter(MQConstants.MQIA_DURABLE_SUB, MQConstants.MQSUB_DURABLE_INHIBITED);
		}
		// DefaultPersistence - optional
		if (WmqTopicDefaultPersistence.AS_PARENT == wmqTopic.getDefaultPersistence()) {
			pcfCmd.addParameter(MQConstants.MQIA_TOPIC_DEF_PERSISTENCE, MQConstants.MQPER_PERSISTENCE_AS_PARENT);

		} else if (WmqTopicDefaultPersistence.PERSISTENT == wmqTopic.getDefaultPersistence()) {

			pcfCmd.addParameter(MQConstants.MQIA_TOPIC_DEF_PERSISTENCE, MQConstants.MQPER_PERSISTENT);
		} else if (WmqTopicDefaultPersistence.NOT_PERSISTENT == wmqTopic.getDefaultPersistence()) {

			pcfCmd.addParameter(MQConstants.MQIA_TOPIC_DEF_PERSISTENCE, MQConstants.MQPER_NOT_PERSISTENT);
		}

		// DefaultPriority - optional

		if (wmqTopic.getDefaultPriority() < 0 || wmqTopic.getDefaultPriority() > 9) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_PRIORITY, MQConstants.MQPRI_PRIORITY_AS_PARENT);
		} else {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_PRIORITY, wmqTopic.getDefaultPriority());
		}

		// ModelDurableQueue - optional

		pcfCmd.addParameter(MQConstants.MQCA_MODEL_DURABLE_Q, wmqTopic.getModelDurableQueue());

		// ModelNonDurableQueue - optional
		pcfCmd.addParameter(MQConstants.MQCA_MODEL_NON_DURABLE_Q, wmqTopic.getModelNonDurableQueue());

		// PublicationScope - optional
		if (WmqPublicationScope.AS_PARENT == wmqTopic.getPublicationScope()) {
			pcfCmd.addParameter(MQConstants.MQIA_PUB_SCOPE, MQConstants.MQSCOPE_AS_PARENT);

		} else if (WmqPublicationScope.QUEUE_MANAGER == wmqTopic.getPublicationScope()) {

			pcfCmd.addParameter(MQConstants.MQIA_PUB_SCOPE, MQConstants.MQSCOPE_QMGR);
		} else if (WmqPublicationScope.ALL == wmqTopic.getPublicationScope()) {

			pcfCmd.addParameter(MQConstants.MQIA_PUB_SCOPE, MQConstants.MQSCOPE_ALL);
		}

		// SubscriptionScope - optional

		if (WmqSubscriptionScope.AS_PARENT == wmqTopic.getSubscriptionScope()) {
			pcfCmd.addParameter(MQConstants.MQIA_SUB_SCOPE, MQConstants.MQSCOPE_AS_PARENT);

		} else if (WmqSubscriptionScope.QUEUE_MANAGER == wmqTopic.getSubscriptionScope()) {

			pcfCmd.addParameter(MQConstants.MQIA_SUB_SCOPE, MQConstants.MQSCOPE_QMGR);
		} else if (WmqSubscriptionScope.ALL == wmqTopic.getSubscriptionScope()) {

			pcfCmd.addParameter(MQConstants.MQIA_SUB_SCOPE, MQConstants.MQSCOPE_ALL);

		}

		// DefaultPutResponseType - optional

		if (WmqTopicDefaultPutResponseType.AS_PARENT == wmqTopic.getDefaultPutResponseType()) {
			pcfCmd.addParameter(MQConstants.MQIA_DEF_PUT_RESPONSE_TYPE, MQConstants.MQPRT_RESPONSE_AS_PARENT);

		} else if (WmqTopicDefaultPutResponseType.SYNCRONOUS == wmqTopic.getDefaultPutResponseType()) {

			pcfCmd.addParameter(MQConstants.MQIA_DEF_PUT_RESPONSE_TYPE, MQConstants.MQPRT_SYNC_RESPONSE);
		} else if (WmqTopicDefaultPutResponseType.ASYNCHRONOUS == wmqTopic.getDefaultPutResponseType()) {

			pcfCmd.addParameter(MQConstants.MQIA_DEF_PUT_RESPONSE_TYPE, MQConstants.MQPRT_ASYNC_RESPONSE);

		}

		// NonPersistentMessageDelivery - optional

		if (WmqNonPersistentMessageDelivery.AS_PARENT == wmqTopic.getNonPersistentMessageDelivery()) {
			pcfCmd.addParameter(MQConstants.MQIA_NPM_DELIVERY, MQConstants.MQDLV_AS_PARENT);

		} else if (WmqNonPersistentMessageDelivery.TO_ALL_SUBSCRIBERS == wmqTopic.getNonPersistentMessageDelivery()) {

			pcfCmd.addParameter(MQConstants.MQIA_NPM_DELIVERY, MQConstants.MQDLV_ALL);
		} else if (WmqNonPersistentMessageDelivery.TO_ALL_DURABLE_SUBSCRIBERS == wmqTopic.getNonPersistentMessageDelivery()) {

			pcfCmd.addParameter(MQConstants.MQIA_NPM_DELIVERY, MQConstants.MQDLV_ALL_DUR);
		} else if (WmqNonPersistentMessageDelivery.TO_ALL_AVILABLE_SUBSCRIBERS == wmqTopic.getNonPersistentMessageDelivery()) {

			pcfCmd.addParameter(MQConstants.MQIA_NPM_DELIVERY, MQConstants.MQDLV_ALL_AVAIL);
		}

		// PersistentMessageDelivery - optional

		if (WmqPersistentMessageDelivery.AS_PARENT == wmqTopic.getPersistentMessageDelivery()) {
			pcfCmd.addParameter(MQConstants.MQIA_PM_DELIVERY, MQConstants.MQDLV_AS_PARENT);

		} else if (WmqPersistentMessageDelivery.TO_ALL_SUBSCRIBERS == wmqTopic.getPersistentMessageDelivery()) {

			pcfCmd.addParameter(MQConstants.MQIA_PM_DELIVERY, MQConstants.MQDLV_ALL);
		} else if (WmqPersistentMessageDelivery.TO_ALL_DURABLE_SUBSCRIBERS == wmqTopic.getPersistentMessageDelivery()) {

			pcfCmd.addParameter(MQConstants.MQIA_PM_DELIVERY, MQConstants.MQDLV_ALL_DUR);
		} else if (WmqPersistentMessageDelivery.TO_ALL_AVILABLE_SUBSCRIBERS == wmqTopic.getPersistentMessageDelivery()) {

			pcfCmd.addParameter(MQConstants.MQIA_PM_DELIVERY, MQConstants.MQDLV_ALL_AVAIL);
		}

		// WildcardOperation - optional

		if (WmqWildcardOperation.PASSTHROUGH == wmqTopic.getWildcardOperation()) {
			pcfCmd.addParameter(MQConstants.MQIA_WILDCARD_OPERATION, MQConstants.MQTA_PASSTHRU);

		} else if (WmqWildcardOperation.BLOCK == wmqTopic.getWildcardOperation()) {

			pcfCmd.addParameter(MQConstants.MQIA_WILDCARD_OPERATION, MQConstants.MQTA_BLOCK);
		}

		// ProxySubscriptionBehavior - optional

		if (WmqProxySubscriptionBehavior.FIRST_USE == wmqTopic.getProxySubscriptionBehavior()) {
			pcfCmd.addParameter(MQConstants.MQIA_PROXY_SUB, MQConstants.MQTA_PROXY_SUB_FIRSTUSE);

		} else if (WmqProxySubscriptionBehavior.FORCE == wmqTopic.getProxySubscriptionBehavior()) {

			pcfCmd.addParameter(MQConstants.MQIA_PROXY_SUB, MQConstants.MQTA_PROXY_SUB_FORCE);
		}

		// ClusterName - optional

		pcfCmd.addParameter(MQConstants.MQCA_CLUSTER_NAME, wmqTopic.getClusterName());

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Modifying the Topic \"" + wmqTopic.getTopicName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Modify Topic with PCF";
	}

	@Override
	protected String getSuccessMessage() {

		return "The Topic \"" + wmqTopic.getTopicName() + "\" is modified on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
	}

}
