/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqReceiverChannel;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPutAuthority;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonpersistentMessageSpeed;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLClientAuthentication;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

/**
 * Creates a {@link WmqReceiverChannel} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqReceiverChannelStep extends BaseWmqStep {

	public WmqReceiverChannel wmqReceiverChannel;

	public CreateWmqReceiverChannelStep(WmqReceiverChannel wmqReceiverChannel, WmqQueueManager wmqQmanager) {
		this.wmqQmanager = wmqQmanager;
		this.wmqReceiverChannel = wmqReceiverChannel;

	}

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_CREATE_CHANNEL;

	}

	@Override
	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// Setting MQ ReceiverChannelame
		pcfCmd.addParameter(MQConstants.MQCACH_CHANNEL_NAME, wmqReceiverChannel.getChannelName());

		// Setting MQ ReceiverChannelType
		pcfCmd.addParameter(MQConstants.MQIACH_CHANNEL_TYPE, MQConstants.MQCHT_RECEIVER);

		// Setting MQ ReceiverChannel Description
		if (StringUtils.isNotBlank(wmqReceiverChannel.getDescription())) {

			pcfCmd.addParameter(MQConstants.MQCACH_DESC, wmqReceiverChannel.getDescription());
		}

		// Setting MQ ReceiverChannel Transport Type
		if (WmqTransmissionProtocolTypes.LU6 == wmqReceiverChannel.getTransportType()) {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_LU62);

		} else if (WmqTransmissionProtocolTypes.NET_BIOS == wmqReceiverChannel.getTransportType()) {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_NETBIOS);

		} else if (WmqTransmissionProtocolTypes.SPX == wmqReceiverChannel.getTransportType()) {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_SPX);
		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_TCP);
		}

		// Setting MQ ReceiverChannel HeaderCompression value
		int[] messageCompressionList = new int[1];
		if (WmqHeaderCompression.SYSTEM == wmqReceiverChannel.getHeaderCompression()) {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_SYSTEM;

			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		} else {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_NONE;
			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		}

		// Setting MQ ReceiverChannel HeartbeatInterval
		pcfCmd.addParameter(MQConstants.MQIACH_HB_INTERVAL, wmqReceiverChannel.getHeartBeatInterval());

		// Setting MQ ReceiverChannel KeepaliveInterval
		if (wmqReceiverChannel.getKeepAliveInterval() > -1 && wmqReceiverChannel.getKeepAliveInterval() <= 99999) {
			pcfCmd.addParameter(MQConstants.MQIACH_KEEP_ALIVE_INTERVAL, wmqReceiverChannel.getKeepAliveInterval());
		}

		// Setting MQ ReceiverChannel MaximumMessageLength
		pcfCmd.addParameter(MQConstants.MQIACH_MAX_MSG_LENGTH, wmqReceiverChannel.getMaximumMessageLength());

		// Setting MQ ReceiverChannel maximum message sequence number
		if (wmqReceiverChannel.getSequenceNumberWrap() < 100) {
			pcfCmd.addParameter(MQConstants.MQIACH_SEQUENCE_NUMBER_WRAP, 999999999);
		} else if (wmqReceiverChannel.getSequenceNumberWrap() != 0) {

			pcfCmd.addParameter(MQConstants.MQIACH_SEQUENCE_NUMBER_WRAP, wmqReceiverChannel.getSequenceNumberWrap());
		}

		// Setting MQ ReceiverChannel MessageCompression Value
		if (WmqChannelMessageCompression.ANY == wmqReceiverChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ANY;

			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		} else if (WmqChannelMessageCompression.RLE == wmqReceiverChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_RLE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqChannelMessageCompression.ZLIBFAST == wmqReceiverChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBFAST;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqChannelMessageCompression.ZLIBHIGH == wmqReceiverChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBHIGH;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		} else {
			messageCompressionList[0] = MQConstants.MQCOMPRESS_NONE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		}

		// Setting MQ ReceiverChannel NonPersistentMessageSpeed
		if (WmqNonpersistentMessageSpeed.NORMAL == wmqReceiverChannel.getNonPersistentMessageSpeed()) {

			pcfCmd.addParameter(MQConstants.MQIACH_NPM_SPEED, MQConstants.MQNPMS_NORMAL);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_NPM_SPEED, MQConstants.MQNPMS_FAST);
		}

		// Setting MQ ReceiverChannel BatchSize
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_SIZE, wmqReceiverChannel.getBatchSize());

		// Setting MQ ReceiverChannel PutAuthority

		if (WmqChannelPutAuthority.CONTEXT == wmqReceiverChannel.getPutAuthority()) {

			pcfCmd.addParameter(MQConstants.MQIACH_PUT_AUTHORITY, MQConstants.MQPA_CONTEXT);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_PUT_AUTHORITY, MQConstants.MQPA_DEFAULT);
		}

		// Setting MQ ReceiverChannel MCAUserID
		if (StringUtils.isNotBlank(wmqReceiverChannel.getMcaUserID())) {

			pcfCmd.addParameter(MQConstants.MQCACH_MCA_USER_ID, wmqReceiverChannel.getMcaUserID());

		}

		// Setting MQ ReceiverChannel SendExitname
		if (StringUtils.isNotBlank(wmqReceiverChannel.getSendExit())) {

			String[] sendExitList = StringUtils.split(wmqReceiverChannel.getSendExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_NAME, sendExitList);

		}

		// Setting MQ ReceiverChannel SendUserData
		if (StringUtils.isNotBlank(wmqReceiverChannel.getSendExitUserData())) {

			String[] sendExitUserDataList = StringUtils.split(wmqReceiverChannel.getSendExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_USER_DATA, sendExitUserDataList);
		}

		// Setting MQ ReceiverChannel ReceiveExit
		if (StringUtils.isNotBlank(wmqReceiverChannel.getReceiveExit())) {

			String[] receiveExitList = StringUtils.split(wmqReceiverChannel.getReceiveExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_NAME, receiveExitList);
		}

		// Setting MQ ReceiverChannel ReceiveUserData
		if (StringUtils.isNotBlank(wmqReceiverChannel.getReceiveExitUserData())) {

			String[] receiveExitUserDataList = StringUtils.split(wmqReceiverChannel.getReceiveExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_USER_DATA, receiveExitUserDataList);
		}

		// Setting MQ ReceiverChannel SecurityExit
		if (StringUtils.isNotBlank(wmqReceiverChannel.getSecurityExit())) {

			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_NAME, wmqReceiverChannel.getSecurityExit());
		}

		// Setting MQ ReceiverChannel SecurityUserData
		if (StringUtils.isNotBlank(wmqReceiverChannel.getSecurityExitUserData())) {

			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_USER_DATA, wmqReceiverChannel.getSecurityExitUserData());
		}

		// Setting MQ ReceiverChannel MsgExit
		if (StringUtils.isNotBlank(wmqReceiverChannel.getMessageExitName())) {

			String[] messageExitList = StringUtils.split(wmqReceiverChannel.getMessageExitName(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_MSG_EXIT_NAME, messageExitList);
		}

		// Setting MQ ReceiverChannel MsgUserData
		if (StringUtils.isNotBlank(wmqReceiverChannel.getMessageExitUserData())) {

			String[] messageExitUserList = StringUtils.split(wmqReceiverChannel.getMessageExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_MSG_EXIT_USER_DATA, messageExitUserList);
		}

		// Setting MQ ReceiverChannel MessageRetryCount
		pcfCmd.addParameter(MQConstants.MQIACH_MR_COUNT, wmqReceiverChannel.getMessageRetryCount());

		// Setting MQ ReceiverChannel MessageRetryInterval
		pcfCmd.addParameter(MQConstants.MQIACH_MR_INTERVAL, wmqReceiverChannel.getMessageRetryInterval());

		// Setting MQ ReceiverChannel MessageRetryExitname
		if (StringUtils.isNotBlank(wmqReceiverChannel.getMessageRetryExitname())) {

			pcfCmd.addParameter(MQConstants.MQCACH_MR_EXIT_NAME, wmqReceiverChannel.getMessageRetryExitname());

		}

		// Setting MQ ReceiverChannel MessageRetryExitUserData
		if (StringUtils.isNotBlank(wmqReceiverChannel.getMessageRetryExitUserData())) {

			pcfCmd.addParameter(MQConstants.MQCACH_MR_EXIT_USER_DATA, wmqReceiverChannel.getMessageRetryExitUserData());

		}

		// Setting MQ ReceiverChannel Monitoring
		if (WmqChannelMonitoring.HIGH == wmqReceiverChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_HIGH);

		} else if (WmqChannelMonitoring.LOW == wmqReceiverChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_LOW);

		} else if (WmqChannelMonitoring.MEDIUM == wmqReceiverChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_MEDIUM);

		} else if (WmqChannelMonitoring.OFF == wmqReceiverChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_OFF);

		} else {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_Q_MGR);
		}

		// Setting MQ ReceiverChannel Statistics
		if (WmqChannelStatisticTypes.HIGH == wmqReceiverChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_HIGH);

		} else if (WmqChannelStatisticTypes.LOW == wmqReceiverChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_LOW);

		} else if (WmqChannelStatisticTypes.MEDIUM == wmqReceiverChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_MEDIUM);

		} else if (WmqChannelStatisticTypes.OFF == wmqReceiverChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_OFF);

		} else {
			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_Q_MGR);
		}

		// Setting MQ ReceiverChannel SSLCipherSpec
		if (wmqReceiverChannel.getSslCipherSpecification() != null) {

			pcfCmd.addParameter(MQConstants.MQCACH_SSL_CIPHER_SPEC, wmqReceiverChannel.getSslCipherSpecification().toString());
		}

		// Setting MQ ReceiverChannel Client authentication
		if (WmqSSLClientAuthentication.OPTIONAL == wmqReceiverChannel.getSslClientAuth()) {

			pcfCmd.addParameter(MQConstants.MQIACH_SSL_CLIENT_AUTH, MQConstants.MQSCA_OPTIONAL);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_SSL_CLIENT_AUTH, MQConstants.MQSCA_REQUIRED);
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating ReceiverChannel \"" + wmqReceiverChannel.getChannelName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName()
			        + "\"";
		}
		return "Creating ReceiverChannel Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The ReceiverChannel \"" + wmqReceiverChannel.getChannelName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName()
		        + "\"";

	}

}
