/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.utils.RegexUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckWmqListenerPortStep
implements Step {
    private WmqQueueManager wmqQueueManager;

    public CheckWmqListenerPortStep(WmqQueueManager wmqQueueManager) {
        this.wmqQueueManager = wmqQueueManager;
    }

    public boolean execute(StepExecutionContext ctx) {
        boolean checkPortRunning = this.checkListenerPortRunning(ctx);
        if (!checkPortRunning) {
            ctx.logOutput("Getting TCP Listeners Names and starting");
            List<String> listenerList = this.getListnerNames(ctx);
            for (String listenerName : listenerList) {
                this.startListenerPort(ctx, listenerName);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            checkPortRunning = this.checkListenerPortRunning(ctx);
        }
        return checkPortRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getListnerNames(StepExecutionContext ctx) {
        HostSession hostSession = this.wmqQueueManager.getHostName().getHostSession();
        ArrayList<String> listenerNames = new ArrayList<String>();
        try {
            CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
            ArrayList<String> cmd = new ArrayList<String>();
            if (this.wmqQueueManager.getHostName().getOperatingSystemFamily() == OperatingSystemFamily.WINDOWS) {
                cmd.add("cmd");
                cmd.add("/c");
            }
            cmd.add("echo");
            cmd.add("dis");
            cmd.add("lstr(*)");
            cmd.add("port");
            cmd.add("trptype(tcp)");
            cmd.add("|");
            cmd.add("runmqsc");
            cmd.add(this.wmqQueueManager.getQueueManagerName());
            Object[] cmdArray = cmd.toArray(new String[cmd.size()]);
            int res = hostSession.execute((CommandExecutionCallbackHandler)capturedOutput, (String[])cmdArray);
            if (res != 0) {
                ctx.logError("Non-zero exitcode from " + StringUtils.join((Object[])cmdArray, (String)" ") + ": " + res);
                ArrayList<String> arrayList = listenerNames;
                return arrayList;
            }
            for (String eachLine : capturedOutput.getOutputLines()) {
                String[] matches;
                if (!eachLine.contains("PORT") || (matches = RegexUtils.regexMatch(eachLine, "[\\s\\S]*\\((\\S+)\\)\\s+PORT\\((\\d+)\\)")) == null || matches.length != 2) continue;
                listenerNames.add(matches[0]);
            }
        }
        finally {
            hostSession.close();
        }
        ctx.logOutput("Available Tcp Listener Names on the QueueManager \"" + this.wmqQueueManager.getQueueManagerName() + "\"" + listenerNames);
        return listenerNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startListenerPort(StepExecutionContext ctx, String listenerName) {
        HostSession hostSession = this.wmqQueueManager.getHostName().getHostSession();
        try {
            CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
            ArrayList<String> cmd = new ArrayList<String>();
            if (this.wmqQueueManager.getHostName().getOperatingSystemFamily() == OperatingSystemFamily.WINDOWS) {
                cmd.add("cmd");
                cmd.add("/c");
            }
            cmd.add("echo");
            cmd.add("start");
            cmd.add("lstr('" + listenerName + "')");
            cmd.add("|");
            cmd.add("runmqsc");
            cmd.add(this.wmqQueueManager.getQueueManagerName());
            String[] cmdArray = cmd.toArray(new String[cmd.size()]);
            hostSession.execute((CommandExecutionCallbackHandler)capturedOutput, cmdArray);
        }
        finally {
            hostSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkListenerPortRunning(StepExecutionContext ctx) {
        HostSession hostSession = this.wmqQueueManager.getHostName().getHostSession();
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
            ArrayList<String> cmd = new ArrayList<String>();
            if (this.wmqQueueManager.getHostName().getOperatingSystemFamily() == OperatingSystemFamily.WINDOWS) {
                cmd.add("cmd");
                cmd.add("/c");
            }
            cmd.add("echo");
            cmd.add("dis");
            cmd.add("lsstatus(*)");
            cmd.add("port");
            cmd.add("trptype");
            cmd.add("|");
            cmd.add("runmqsc");
            cmd.add(this.wmqQueueManager.getQueueManagerName());
            Object[] cmdArray = cmd.toArray(new String[cmd.size()]);
            int res = hostSession.execute((CommandExecutionCallbackHandler)capturedOutput, (String[])cmdArray);
            if (res != 0) {
                ctx.logError("Non-zero exitcode from " + StringUtils.join((Object[])cmdArray, (String)" ") + ": " + res);
                boolean bl = false;
                return bl;
            }
            boolean isTCPPort = false;
            for (String eachLine : capturedOutput.getOutputLines()) {
                int portNumber;
                String[] matches;
                if (eachLine.contains("TRPTYPE")) {
                    matches = RegexUtils.regexMatch(eachLine, "[\\s\\S]*TRPTYPE\\((TCP)\\)");
                    if (matches == null || matches.length != 1) continue;
                    isTCPPort = true;
                    continue;
                }
                if (!eachLine.contains("PORT")) continue;
                matches = RegexUtils.regexMatch(eachLine, "[\\s]*PORT\\((\\d+)\\)[\\s]*");
                if (isTCPPort && matches != null && matches.length == 1 && (portNumber = Integer.parseInt(matches[0])) != 0) {
                    list.add(portNumber);
                }
                isTCPPort = false;
            }
        }
        finally {
            hostSession.close();
        }
        if (list.size() > 0) {
            ctx.logOutput("Availble Port numbers on the QueueManager \"" + this.wmqQueueManager.getQueueManagerName() + "\"" + list);
            this.wmqQueueManager.setPortNumber((Integer)list.get(0));
            ctx.logOutput("The port \"" + list.get(0) + "\" is set to the QueueManager \"" + this.wmqQueueManager.getQueueManagerName() + "\"");
            if (list.size() > 1) {
                ctx.logOutput("User can change the port number on the QueueManager after the discovery process is completed to any of the above mentioned Port Numbers");
            }
            return true;
        }
        ctx.logError("Port Number of  Queue Manager \"" + this.wmqQueueManager.getQueueManagerName() + "\" is not available");
        ctx.logError("Start TCP Listener on the Queue Manger ");
        return false;
    }

    public String getDescription() {
        if (this.wmqQueueManager.getQueueManagerName() != null) {
            return "Check WmqListenerPort Step for \"" + this.wmqQueueManager.getQueueManagerName() + "\"";
        }
        return "Check WmqListenerPort Step";
    }
}

