/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqClusterSenderChannel;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMCAType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDataConversion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonpersistentMessageSpeed;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

public class CreateWmqClusterSenderChannelStep
extends BaseWmqStep {
    public WmqClusterSenderChannel wmqClusterSenderChannel;
    private int[] messageCompressionList = new int[1];

    public CreateWmqClusterSenderChannelStep(WmqClusterSenderChannel wmqClusterSenderChannel, WmqQueueManager wmqQmanager) {
        this.wmqClusterSenderChannel = wmqClusterSenderChannel;
        this.wmqQmanager = wmqQmanager;
    }

    protected void init() {
        this.mqCommand = 23;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        int[] list;
        pcfCmd.addParameter(3501, this.wmqClusterSenderChannel.getChannelName());
        pcfCmd.addParameter(1511, 9);
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getDescription())) {
            pcfCmd.addParameter(3502, this.wmqClusterSenderChannel.getDescription());
        }
        if (WmqTransmissionProtocolTypes.LU6 == this.wmqClusterSenderChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 1);
        } else if (WmqTransmissionProtocolTypes.NET_BIOS == this.wmqClusterSenderChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 3);
        } else if (WmqTransmissionProtocolTypes.SPX == this.wmqClusterSenderChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 4);
        } else {
            pcfCmd.addParameter(1501, 2);
        }
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getConnectionName())) {
            pcfCmd.addParameter(3506, this.wmqClusterSenderChannel.getConnectionName());
        }
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getLocalCommunicationAddress())) {
            pcfCmd.addParameter(3520, this.wmqClusterSenderChannel.getLocalCommunicationAddress());
        }
        if (WmqHeaderCompression.SYSTEM == this.wmqClusterSenderChannel.getHeaderCompression()) {
            list = new int[]{8};
            pcfCmd.addParameter(1575, list);
        } else {
            list = new int[]{0};
            pcfCmd.addParameter(1575, list);
        }
        if (this.wmqClusterSenderChannel.getKeepAliveInterval() > -1 && this.wmqClusterSenderChannel.getKeepAliveInterval() <= 99999) {
            pcfCmd.addParameter(1566, this.wmqClusterSenderChannel.getKeepAliveInterval());
        }
        pcfCmd.addParameter(1563, this.wmqClusterSenderChannel.getHeartBeatInterval());
        pcfCmd.addParameter(1510, this.wmqClusterSenderChannel.getMaximumMessageLength());
        if (this.wmqClusterSenderChannel.getSequenceNumberWrap() < 100) {
            pcfCmd.addParameter(1509, 999999999);
        } else if (this.wmqClusterSenderChannel.getSequenceNumberWrap() != 0) {
            pcfCmd.addParameter(1509, this.wmqClusterSenderChannel.getSequenceNumberWrap());
        }
        if (WmqMessageCompression.RLE == this.wmqClusterSenderChannel.getMessageCompression()) {
            this.messageCompressionList[0] = 1;
            pcfCmd.addParameter(1576, this.messageCompressionList);
        } else if (WmqMessageCompression.ZLIBFAST == this.wmqClusterSenderChannel.getMessageCompression()) {
            this.messageCompressionList[0] = 2;
            pcfCmd.addParameter(1576, this.messageCompressionList);
        } else if (WmqMessageCompression.ZLIBHIGH == this.wmqClusterSenderChannel.getMessageCompression()) {
            this.messageCompressionList[0] = 4;
            pcfCmd.addParameter(1576, this.messageCompressionList);
        } else {
            this.messageCompressionList[0] = 0;
            pcfCmd.addParameter(1576, this.messageCompressionList);
        }
        if (WmqNonpersistentMessageSpeed.NORMAL == this.wmqClusterSenderChannel.getNonPersistentMessageSpeed()) {
            pcfCmd.addParameter(1562, 1);
        } else {
            pcfCmd.addParameter(1562, 2);
        }
        pcfCmd.addParameter(1502, this.wmqClusterSenderChannel.getBatchSize());
        pcfCmd.addParameter(1564, this.wmqClusterSenderChannel.getBatchInterval());
        pcfCmd.addParameter(1503, this.wmqClusterSenderChannel.getDisconnectInterval());
        if (WmqDataConversion.CONVERSION == this.wmqClusterSenderChannel.getDataConversion()) {
            pcfCmd.addParameter(1515, 1);
        } else {
            pcfCmd.addParameter(1515, 0);
        }
        pcfCmd.addParameter(1567, this.wmqClusterSenderChannel.getBatchHeartBeatInterval());
        if (this.wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
            if (WmqChannelPropertyControl.ALL == this.wmqClusterSenderChannel.getPropertyControl()) {
                pcfCmd.addParameter(190, 2);
            } else if (WmqChannelPropertyControl.NONE == this.wmqClusterSenderChannel.getPropertyControl()) {
                pcfCmd.addParameter(190, 1);
            } else {
                pcfCmd.addParameter(190, 0);
            }
        }
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getClusterName())) {
            pcfCmd.addParameter(2029, this.wmqClusterSenderChannel.getClusterName());
        }
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getClusterNamelist())) {
            pcfCmd.addParameter(2030, this.wmqClusterSenderChannel.getClusterNamelist());
        }
        pcfCmd.addParameter(1577, this.wmqClusterSenderChannel.getClusterWorkloadChannelRank());
        pcfCmd.addParameter(1578, this.wmqClusterSenderChannel.getClusterWorkloadChannelPriority());
        pcfCmd.addParameter(1579, this.wmqClusterSenderChannel.getClusterWorkloadChannelWeight());
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getMcaUserID())) {
            pcfCmd.addParameter(3527, this.wmqClusterSenderChannel.getMcaUserID());
        }
        if (WmqChannelMCAType.THREAD == this.wmqClusterSenderChannel.getMcaType()) {
            pcfCmd.addParameter(1517, 2);
        } else {
            pcfCmd.addParameter(1517, 1);
        }
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getSendExit())) {
            String[] sendExitList = StringUtils.split(this.wmqClusterSenderChannel.getSendExit(), ",");
            pcfCmd.addParameter(3510, sendExitList);
        }
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getSendExitUserData())) {
            String[] sendExitUserDataList = StringUtils.split(this.wmqClusterSenderChannel.getSendExitUserData(), ",");
            pcfCmd.addParameter(3515, sendExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getReceiveExit())) {
            String[] receiveExitList = StringUtils.split(this.wmqClusterSenderChannel.getReceiveExit(), ",");
            pcfCmd.addParameter(3511, receiveExitList);
        }
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getReceiveExitUserData())) {
            String[] receiveExitUserDataList = StringUtils.split(this.wmqClusterSenderChannel.getReceiveExitUserData(), ",");
            pcfCmd.addParameter(3516, receiveExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getSecurityExit())) {
            pcfCmd.addParameter(3508, this.wmqClusterSenderChannel.getSecurityExit());
        }
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getSecurityExitUserData())) {
            pcfCmd.addParameter(3513, this.wmqClusterSenderChannel.getSecurityExitUserData());
        }
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getMessageExitName())) {
            String[] messageExitList = StringUtils.split(this.wmqClusterSenderChannel.getMessageExitName(), ",");
            pcfCmd.addParameter(3509, messageExitList);
        }
        if (StringUtils.isNotBlank(this.wmqClusterSenderChannel.getMessageExitUserData())) {
            String[] messageExitUserList = StringUtils.split(this.wmqClusterSenderChannel.getMessageExitUserData(), ",");
            pcfCmd.addParameter(3514, messageExitUserList);
        }
        pcfCmd.addParameter(1505, this.wmqClusterSenderChannel.getShortRetryCount());
        pcfCmd.addParameter(1504, this.wmqClusterSenderChannel.getShortRetryInterval());
        pcfCmd.addParameter(1507, this.wmqClusterSenderChannel.getLongRetryCount());
        pcfCmd.addParameter(1506, this.wmqClusterSenderChannel.getLongRetryInterval());
        if (WmqChannelMonitoring.HIGH == this.wmqClusterSenderChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 65);
        } else if (WmqChannelMonitoring.LOW == this.wmqClusterSenderChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 17);
        } else if (WmqChannelMonitoring.MEDIUM == this.wmqClusterSenderChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 33);
        } else if (WmqChannelMonitoring.OFF == this.wmqClusterSenderChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 0);
        } else {
            pcfCmd.addParameter(122, -3);
        }
        if (WmqChannelStatisticTypes.HIGH == this.wmqClusterSenderChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 65);
        } else if (WmqChannelStatisticTypes.LOW == this.wmqClusterSenderChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 17);
        } else if (WmqChannelStatisticTypes.MEDIUM == this.wmqClusterSenderChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 33);
        } else if (WmqChannelStatisticTypes.OFF == this.wmqClusterSenderChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 0);
        } else {
            pcfCmd.addParameter(129, -3);
        }
        if (this.wmqClusterSenderChannel.getSslCipherSpecification() != null) {
            pcfCmd.addParameter(3544, this.wmqClusterSenderChannel.getSslCipherSpecification().toString());
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating ClusterSenderChannel \"" + this.wmqClusterSenderChannel.getChannelName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating ClusterSenderChannel Step";
    }

    protected String getSuccessMessage() {
        return "The ClusterSenderChannel \"" + this.wmqClusterSenderChannel.getChannelName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

