/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqModelQueue;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultInputOpenOption;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPersistence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPutResponseType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultReadAhead;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefinitionType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDistributionLists;
import com.xebialabs.deployit.plugin.wmq.enums.WmqGetMessages;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHardengetBackout;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMessageDeliverySequence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNPMClass;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPutMessage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueAccounting;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthHighEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthLowEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueDepthMaxEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueServiceIntervalEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueStatistics;
import com.xebialabs.deployit.plugin.wmq.enums.WmqShareability;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTriggerControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTriggerType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqUsage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

public class CreateWmqModelQueueStep
extends BaseWmqStep {
    public WmqModelQueue wmqModelQueue;

    protected void init() {
        this.mqCommand = 11;
    }

    public CreateWmqModelQueueStep(WmqModelQueue wmqModelQueue, WmqQueueManager wmqQmanager) {
        this.wmqModelQueue = wmqModelQueue;
        this.wmqQmanager = wmqQmanager;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        pcfCmd.addParameter(2016, this.wmqModelQueue.getQueueName());
        pcfCmd.addParameter(20, 2);
        if (WmqDefaultPersistence.PERSISTENT == this.wmqModelQueue.getDefaultPersistence()) {
            pcfCmd.addParameter(5, 1);
        } else if (WmqDefaultPersistence.NOT_PERSISTENT == this.wmqModelQueue.getDefaultPersistence()) {
            pcfCmd.addParameter(5, 0);
        }
        if (WmqPutMessage.ALLOWED == this.wmqModelQueue.getPutMessages()) {
            pcfCmd.addParameter(10, 0);
        } else if (WmqPutMessage.INHIBITED == this.wmqModelQueue.getPutMessages()) {
            pcfCmd.addParameter(10, 1);
        }
        if (StringUtils.isNotBlank(this.wmqModelQueue.getDescription())) {
            pcfCmd.addParameter(2013, this.wmqModelQueue.getDescription());
        }
        pcfCmd.addParameter(6, this.wmqModelQueue.getDefaultPriority());
        if (this.wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
            if (WmqDefaultPutResponseType.SYNCHRONOUS == this.wmqModelQueue.getDefaultPutResponseType()) {
                pcfCmd.addParameter(184, 1);
            } else if (WmqDefaultPutResponseType.ASYNCHRONOUS == this.wmqModelQueue.getDefaultPutResponseType()) {
                pcfCmd.addParameter(184, 2);
            }
            if (WmqDefaultReadAhead.YES == this.wmqModelQueue.getDefaultReadAhead()) {
                pcfCmd.addParameter(188, 1);
            } else if (WmqDefaultReadAhead.NO == this.wmqModelQueue.getDefaultReadAhead()) {
                pcfCmd.addParameter(188, 0);
            } else if (WmqDefaultReadAhead.DISABLED == this.wmqModelQueue.getDefaultReadAhead()) {
                pcfCmd.addParameter(188, 2);
            }
            if (WmqPropertyControl.COMPATABILITY == this.wmqModelQueue.getPropertyControl()) {
                pcfCmd.addParameter(190, 0);
            } else if (WmqPropertyControl.NONE == this.wmqModelQueue.getPropertyControl()) {
                pcfCmd.addParameter(190, 1);
            } else if (WmqPropertyControl.ALL == this.wmqModelQueue.getPropertyControl()) {
                pcfCmd.addParameter(190, 2);
            } else if (WmqPropertyControl.FORCE_MQ_RFH2 == this.wmqModelQueue.getPropertyControl()) {
                pcfCmd.addParameter(190, 3);
            }
        }
        if (WmqGetMessages.ALLOWED == this.wmqModelQueue.getGetMessages()) {
            pcfCmd.addParameter(9, 0);
        } else if (WmqGetMessages.INHIBITED == this.wmqModelQueue.getGetMessages()) {
            pcfCmd.addParameter(9, 1);
        }
        if (WmqDefaultInputOpenOption.INPUT_EXCLUSIVE == this.wmqModelQueue.getDefaultInputOpenOption()) {
            pcfCmd.addParameter(4, 4);
        } else if (WmqDefaultInputOpenOption.INPUT_SHARED == this.wmqModelQueue.getDefaultInputOpenOption()) {
            pcfCmd.addParameter(4, 2);
        }
        if (WmqShareability.SHAREABLE == this.wmqModelQueue.getShareability()) {
            pcfCmd.addParameter(23, 1);
        } else if (WmqShareability.NOT_SHAREABLE == this.wmqModelQueue.getShareability()) {
            pcfCmd.addParameter(23, 0);
        }
        if (WmqDistributionLists.SUPPORTED == this.wmqModelQueue.getDistributionLists()) {
            pcfCmd.addParameter(34, 1);
        } else if (WmqDistributionLists.NOT_SUPPORTED == this.wmqModelQueue.getDistributionLists()) {
            pcfCmd.addParameter(34, 0);
        }
        if (WmqTriggerControl.OFF == this.wmqModelQueue.getTriggerControl()) {
            pcfCmd.addParameter(24, 0);
        } else if (WmqTriggerControl.ON == this.wmqModelQueue.getTriggerControl()) {
            pcfCmd.addParameter(24, 1);
        }
        if (WmqTriggerType.DEPTH == this.wmqModelQueue.getTriggerType()) {
            pcfCmd.addParameter(28, 3);
        } else if (WmqTriggerType.EVERY == this.wmqModelQueue.getTriggerType()) {
            pcfCmd.addParameter(28, 2);
        } else if (WmqTriggerType.FIRST == this.wmqModelQueue.getTriggerType()) {
            pcfCmd.addParameter(28, 1);
        } else if (WmqTriggerType.NONE == this.wmqModelQueue.getTriggerType()) {
            pcfCmd.addParameter(28, 0);
        }
        if (this.wmqModelQueue.getTriggerDepth() != 0) {
            pcfCmd.addParameter(29, this.wmqModelQueue.getTriggerDepth());
        }
        pcfCmd.addParameter(26, this.wmqModelQueue.getTriggerMessagePriority());
        pcfCmd.addParameter(2023, this.wmqModelQueue.getTriggerData());
        if (this.wmqModelQueue.getInitiationQueue() != null && !"".equals(this.wmqModelQueue.getInitiationQueue())) {
            pcfCmd.addParameter(2008, this.wmqModelQueue.getInitiationQueue());
        }
        if (this.wmqModelQueue.getProcessName() != null && !"".equals(this.wmqModelQueue.getProcessName())) {
            pcfCmd.addParameter(2012, this.wmqModelQueue.getProcessName());
        }
        if (WmqQueueDepthMaxEvents.ENABLED == this.wmqModelQueue.getQueueDepthMaxEvents()) {
            pcfCmd.addParameter(42, 1);
        } else if (WmqQueueDepthMaxEvents.DISABLED == this.wmqModelQueue.getQueueDepthMaxEvents()) {
            pcfCmd.addParameter(42, 0);
        }
        if (WmqQueueDepthHighEvents.ENABLED == this.wmqModelQueue.getQueueDepthHighEvents()) {
            pcfCmd.addParameter(43, 1);
        } else if (WmqQueueDepthHighEvents.DISABLED == this.wmqModelQueue.getQueueDepthHighEvents()) {
            pcfCmd.addParameter(43, 0);
        }
        pcfCmd.addParameter(40, this.wmqModelQueue.getQueueDepthHighLimit());
        pcfCmd.addParameter(41, this.wmqModelQueue.getQueueDepthLowLimit());
        if (WmqQueueDepthLowEvents.ENABLED == this.wmqModelQueue.getQueueDepthLowEvents()) {
            pcfCmd.addParameter(44, 1);
        } else if (WmqQueueDepthLowEvents.DISABLED == this.wmqModelQueue.getQueueDepthLowEvents()) {
            pcfCmd.addParameter(44, 0);
        }
        if (WmqQueueServiceIntervalEvents.HIGH == this.wmqModelQueue.getQueueServiceIntervalEvents()) {
            pcfCmd.addParameter(46, 1);
        } else if (WmqQueueServiceIntervalEvents.OK == this.wmqModelQueue.getQueueServiceIntervalEvents()) {
            pcfCmd.addParameter(46, 2);
        } else if (WmqQueueServiceIntervalEvents.NONE == this.wmqModelQueue.getQueueServiceIntervalEvents()) {
            pcfCmd.addParameter(46, 0);
        }
        pcfCmd.addParameter(54, this.wmqModelQueue.getQueueServiceInterval());
        if (this.wmqModelQueue.getBackoutRequeueQueue() != null && !"".equals(this.wmqModelQueue.getBackoutRequeueQueue())) {
            pcfCmd.addParameter(2019, this.wmqModelQueue.getBackoutRequeueQueue());
        }
        pcfCmd.addParameter(22, this.wmqModelQueue.getBackoutThreshold());
        if (WmqHardengetBackout.HARDENED == this.wmqModelQueue.getHardengetBackout()) {
            pcfCmd.addParameter(8, 1);
        } else if (WmqHardengetBackout.NOT_HARDENED == this.wmqModelQueue.getHardengetBackout()) {
            pcfCmd.addParameter(8, 0);
        }
        if (WmqNPMClass.NORMAL == this.wmqModelQueue.getNpmClass()) {
            pcfCmd.addParameter(78, 0);
        } else if (WmqNPMClass.HIGH == this.wmqModelQueue.getNpmClass()) {
            pcfCmd.addParameter(78, 10);
        }
        if (WmqQueueMonitoring.HIGH == this.wmqModelQueue.getQueueMonitoring()) {
            pcfCmd.addParameter(123, 65);
        } else if (WmqQueueMonitoring.LOW == this.wmqModelQueue.getQueueMonitoring()) {
            pcfCmd.addParameter(123, 17);
        } else if (WmqQueueMonitoring.MEDIUM == this.wmqModelQueue.getQueueMonitoring()) {
            pcfCmd.addParameter(123, 33);
        } else if (WmqQueueMonitoring.QUEUE_MANAGER == this.wmqModelQueue.getQueueMonitoring()) {
            pcfCmd.addParameter(123, -3);
        } else if (WmqQueueMonitoring.OFF == this.wmqModelQueue.getQueueMonitoring()) {
            pcfCmd.addParameter(123, 0);
        }
        if (WmqQueueStatistics.ON == this.wmqModelQueue.getQueueStatistics()) {
            pcfCmd.addParameter(128, 1);
        } else if (WmqQueueStatistics.OFF == this.wmqModelQueue.getQueueStatistics()) {
            pcfCmd.addParameter(128, 0);
        } else if (WmqQueueStatistics.QUEUE_MANAGER == this.wmqModelQueue.getQueueStatistics()) {
            pcfCmd.addParameter(128, -3);
        }
        if (WmqQueueAccounting.ON == this.wmqModelQueue.getQueueAccounting()) {
            pcfCmd.addParameter(134, 1);
        } else if (WmqQueueAccounting.OFF == this.wmqModelQueue.getQueueAccounting()) {
            pcfCmd.addParameter(134, 0);
        } else if (WmqQueueAccounting.QUEUE_MANAGER == this.wmqModelQueue.getQueueAccounting()) {
            pcfCmd.addParameter(134, -3);
        }
        pcfCmd.addParameter(15, this.wmqModelQueue.getMaxQueueDepth());
        pcfCmd.addParameter(13, this.wmqModelQueue.getMaxMessageLength());
        if (WmqMessageDeliverySequence.PRIORITY == this.wmqModelQueue.getMessageDeliverySequence()) {
            pcfCmd.addParameter(16, 0);
        } else if (WmqMessageDeliverySequence.FIFO == this.wmqModelQueue.getMessageDeliverySequence()) {
            pcfCmd.addParameter(16, 1);
        }
        if (WmqDefinitionType.TEMPORARY_DYNAMIC == this.wmqModelQueue.getDefifnitionType()) {
            pcfCmd.addParameter(7, 3);
        } else if (WmqDefinitionType.PERMANENT_DYNAMIC == this.wmqModelQueue.getDefifnitionType()) {
            pcfCmd.addParameter(7, 2);
        }
        pcfCmd.addParameter(21, this.wmqModelQueue.getRetentionInterval());
        if (WmqUsage.NORMAL == this.wmqModelQueue.getUsage()) {
            pcfCmd.addParameter(12, 0);
        } else if (WmqUsage.TRANSMISSION == this.wmqModelQueue.getUsage()) {
            pcfCmd.addParameter(12, 1);
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating ModelQueue  \"" + this.wmqModelQueue.getQueueName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating ModelQueue Step";
    }

    protected String getSuccessMessage() {
        return "The ModelQueue \"" + this.wmqModelQueue.getQueueName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

