/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqServerConnectionChannel;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLClientAuthentication;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

public class CreateWmqServerConnectionChannelStep
extends BaseWmqStep {
    public WmqServerConnectionChannel wmqServerConnectionChannel;

    public CreateWmqServerConnectionChannelStep(WmqServerConnectionChannel wmqServerConnectionChannel, WmqQueueManager wmqQmanager) {
        this.wmqServerConnectionChannel = wmqServerConnectionChannel;
        this.wmqQmanager = wmqQmanager;
    }

    protected void init() {
        this.mqCommand = 23;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        int[] list;
        pcfCmd.addParameter(3501, this.wmqServerConnectionChannel.getChannelName());
        pcfCmd.addParameter(1511, 7);
        if (StringUtils.isNotBlank(this.wmqServerConnectionChannel.getDescription())) {
            pcfCmd.addParameter(3502, this.wmqServerConnectionChannel.getDescription());
        }
        if (WmqTransmissionProtocolTypes.LU6 == this.wmqServerConnectionChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 1);
        } else if (WmqTransmissionProtocolTypes.NET_BIOS == this.wmqServerConnectionChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 3);
        } else if (WmqTransmissionProtocolTypes.SPX == this.wmqServerConnectionChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 4);
        } else {
            pcfCmd.addParameter(1501, 2);
        }
        if (WmqHeaderCompression.SYSTEM == this.wmqServerConnectionChannel.getHeaderCompression()) {
            list = new int[]{8};
            pcfCmd.addParameter(1575, list);
        } else {
            list = new int[]{0};
            pcfCmd.addParameter(1575, list);
        }
        pcfCmd.addParameter(1563, this.wmqServerConnectionChannel.getHeartBeatInterval());
        if (this.wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
            pcfCmd.addParameter(1618, this.wmqServerConnectionChannel.getMaximumInstances());
            pcfCmd.addParameter(1619, this.wmqServerConnectionChannel.getMaximumInstancesPerClient());
            pcfCmd.addParameter(1615, this.wmqServerConnectionChannel.getSharingConversations());
        }
        if (this.wmqServerConnectionChannel.getKeepAliveInterval() > -1 && this.wmqServerConnectionChannel.getKeepAliveInterval() <= 99999) {
            pcfCmd.addParameter(1566, this.wmqServerConnectionChannel.getKeepAliveInterval());
        }
        pcfCmd.addParameter(1510, this.wmqServerConnectionChannel.getMaximumMessageLength());
        int[] messageCompressionList = new int[1];
        if (WmqChannelMessageCompression.ANY == this.wmqServerConnectionChannel.getMessageCompression()) {
            messageCompressionList[0] = 0xFFFFFFF;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else if (WmqChannelMessageCompression.RLE == this.wmqServerConnectionChannel.getMessageCompression()) {
            messageCompressionList[0] = 1;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else if (WmqChannelMessageCompression.ZLIBFAST == this.wmqServerConnectionChannel.getMessageCompression()) {
            messageCompressionList[0] = 2;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else if (WmqChannelMessageCompression.ZLIBHIGH == this.wmqServerConnectionChannel.getMessageCompression()) {
            messageCompressionList[0] = 4;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else {
            messageCompressionList[0] = 0;
            pcfCmd.addParameter(1576, messageCompressionList);
        }
        if (StringUtils.isNotBlank(this.wmqServerConnectionChannel.getMcaUserID())) {
            pcfCmd.addParameter(3527, this.wmqServerConnectionChannel.getMcaUserID());
        }
        if (StringUtils.isNotBlank(this.wmqServerConnectionChannel.getSendExit())) {
            String[] sendExitList = StringUtils.split(this.wmqServerConnectionChannel.getSendExit(), ",");
            pcfCmd.addParameter(3510, sendExitList);
        }
        if (StringUtils.isNotBlank(this.wmqServerConnectionChannel.getSendExitUserData())) {
            String[] sendExitUserDataList = StringUtils.split(this.wmqServerConnectionChannel.getSendExitUserData(), ",");
            pcfCmd.addParameter(3515, sendExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqServerConnectionChannel.getReceiveExit())) {
            String[] receiveExitList = StringUtils.split(this.wmqServerConnectionChannel.getReceiveExit(), ",");
            pcfCmd.addParameter(3511, receiveExitList);
        }
        if (StringUtils.isNotBlank(this.wmqServerConnectionChannel.getReceiveExitUserData())) {
            String[] receiveExitUserDataList = StringUtils.split(this.wmqServerConnectionChannel.getReceiveExitUserData(), ",");
            pcfCmd.addParameter(3516, receiveExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqServerConnectionChannel.getSecurityExit())) {
            pcfCmd.addParameter(3508, this.wmqServerConnectionChannel.getSecurityExit());
        }
        if (StringUtils.isNotBlank(this.wmqServerConnectionChannel.getSecurityExitUserData())) {
            pcfCmd.addParameter(3513, this.wmqServerConnectionChannel.getSecurityExitUserData());
        }
        if (WmqChannelMonitoring.HIGH == this.wmqServerConnectionChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 65);
        } else if (WmqChannelMonitoring.LOW == this.wmqServerConnectionChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 17);
        } else if (WmqChannelMonitoring.MEDIUM == this.wmqServerConnectionChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 33);
        } else if (WmqChannelMonitoring.OFF == this.wmqServerConnectionChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 0);
        } else {
            pcfCmd.addParameter(122, -3);
        }
        if (this.wmqServerConnectionChannel.getSslCipherSpecification() != null) {
            pcfCmd.addParameter(3544, this.wmqServerConnectionChannel.getSslCipherSpecification().toString());
        }
        if (WmqSSLClientAuthentication.OPTIONAL == this.wmqServerConnectionChannel.getSslClientAuth()) {
            pcfCmd.addParameter(1568, 1);
        } else {
            pcfCmd.addParameter(1568, 0);
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating ServerConnectionChannel \"" + this.wmqServerConnectionChannel.getChannelName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating ServerConnectionChannel Step";
    }

    protected String getSuccessMessage() {
        return "The ServerConnectionChannel \"" + this.wmqServerConnectionChannel.getChannelName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

