/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqSubscriptions;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDestinationClass;
import com.xebialabs.deployit.plugin.wmq.enums.WmqProperties;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVariableUserId;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqWildCardUsage;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.WmqHelper;

public class CreateWmqSubscriptionStep
extends BaseWmqStep {
    public WmqSubscriptions wmqSubscriptions;

    public CreateWmqSubscriptionStep(WmqSubscriptions wmqSubscriptions, WmqQueueManager wmqQmanager) {
        this.wmqSubscriptions = wmqSubscriptions;
        this.wmqQmanager = wmqQmanager;
    }

    protected void init() {
        if (this.wmqQmanager.getVersion() == WmqVersion.WMQ_60) {
            throw new ResolutionException("Subscription is not supported in MQV6");
        }
        this.mqCommand = 177;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        pcfCmd.addParameter(3152, this.wmqSubscriptions.getSubscriptionName());
        pcfCmd.addParameter(2092, this.wmqSubscriptions.getTopicName());
        pcfCmd.addParameter(2094, this.wmqSubscriptions.getTopicString());
        if (WmqDestinationClass.PROVIDED == this.wmqSubscriptions.getDestinationClass()) {
            pcfCmd.addParameter(3153, this.wmqSubscriptions.getDestinationQueueManager());
            pcfCmd.addParameter(3154, this.wmqSubscriptions.getDestinationName());
        }
        if (WmqSScope.QUEUE_MANAGER == this.wmqSubscriptions.getScope()) {
            pcfCmd.addParameter(1275, 1);
        } else if (WmqSScope.ALL == this.wmqSubscriptions.getScope()) {
            pcfCmd.addParameter(1275, 2);
        }
        if (WmqDestinationClass.PROVIDED == this.wmqSubscriptions.getDestinationClass()) {
            pcfCmd.addParameter(1273, 2);
        } else if (WmqDestinationClass.MANAGED == this.wmqSubscriptions.getDestinationClass()) {
            pcfCmd.addParameter(1273, 1);
        }
        if (WmqProperties.COMPATABILITY == this.wmqSubscriptions.getProperties()) {
            pcfCmd.addParameter(1271, 1);
        } else if (WmqProperties.NONE == this.wmqSubscriptions.getProperties()) {
            pcfCmd.addParameter(1271, 0);
        } else if (WmqProperties.RFH2 == this.wmqSubscriptions.getProperties()) {
            pcfCmd.addParameter(1271, 2);
        }
        pcfCmd.addParameter(3160, this.wmqSubscriptions.getSelector());
        if (WmqVariableUserId.ANY == this.wmqSubscriptions.getVariableUserId()) {
            pcfCmd.addParameter(1277, 2);
        } else if (WmqVariableUserId.FIXED == this.wmqSubscriptions.getVariableUserId()) {
            pcfCmd.addParameter(1277, 1);
        }
        pcfCmd.addParameter(3159, this.wmqSubscriptions.getUserData());
        pcfCmd.addParameter(3135, this.wmqSubscriptions.getApplicationIdentity());
        this.setPriorityValue(pcfCmd);
        if (WmqWildCardUsage.TOPIC_LEVEL_WILDCARD == this.wmqSubscriptions.getWildCardUsage()) {
            pcfCmd.addParameter(1288, 2);
        } else if (WmqWildCardUsage.CHARACTER_LEVEL_WILDCARD == this.wmqSubscriptions.getWildCardUsage()) {
            pcfCmd.addParameter(1288, 1);
        }
        pcfCmd.addParameter(1307, this.wmqSubscriptions.getSubscriptionLevel());
        if (this.wmqSubscriptions.getExpiry() != 0) {
            pcfCmd.addParameter(1244, this.wmqSubscriptions.getExpiry());
        }
    }

    private void setPriorityValue(PCFMessage pcfCmd) {
        if (this.wmqSubscriptions.getPublishPriority() != null) {
            int priorityValue = WmqHelper.getSubscriptionPriority(this.wmqSubscriptions.getPublishPriority().toString());
            pcfCmd.addParameter(1283, priorityValue);
        } else {
            pcfCmd.addParameter(1283, -3);
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating Subscription \"" + this.wmqSubscriptions.getSubscriptionName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating Subscription Step";
    }

    protected String getSuccessMessage() {
        return "The Subscription \"" + this.wmqSubscriptions.getSubscriptionName() + "\" is created on QueueManager\"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

