/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqSubscriptions;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;

public class DestroyWmqSubscriptionStep
extends BaseWmqStep {
    private WmqSubscriptions wmqSubscriptions;

    public DestroyWmqSubscriptionStep() {
    }

    protected void init() {
        if (this.wmqQmanager.getVersion() == WmqVersion.WMQ_60) {
            throw new ResolutionException("Subscription is not supported in MQV6");
        }
        this.mqCommand = 179;
    }

    public DestroyWmqSubscriptionStep(WmqSubscriptions wmqSubscriptions, WmqQueueManager wmqQmanager) {
        this.wmqSubscriptions = wmqSubscriptions;
        this.wmqQmanager = wmqQmanager;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        pcfCmd.addParameter(3152, this.wmqSubscriptions.getSubscriptionName());
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Deleting subscription \"" + this.wmqSubscriptions.getSubscriptionName() + "\" from QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Deleting subscription with PCF";
    }

    protected String getSuccessMessage() {
        return "The Subscription \"" + this.wmqSubscriptions.getSubscriptionName() + "\" is deleted from QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

