/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.utils.RegexUtils;
import java.util.ArrayList;

public class DisplayWmqQueueManagerStatusStep
implements Step {
    private WmqQueueManager wmqQueueManager;
    private boolean isDeployment = false;

    public DisplayWmqQueueManagerStatusStep(WmqQueueManager wmqQueueManager) {
        this.wmqQueueManager = wmqQueueManager;
    }

    public DisplayWmqQueueManagerStatusStep(WmqQueueManager wmqQueueManager, boolean isDeployment) {
        this.wmqQueueManager = wmqQueueManager;
        this.isDeployment = isDeployment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession hostSession = this.wmqQueueManager.getHostName().getHostSession();
        try {
            CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("dspmq");
            cmd.add("-m");
            cmd.add(this.wmqQueueManager.getQueueManagerName());
            String[] cmdArray = cmd.toArray(new String[cmd.size()]);
            int res = hostSession.execute((CommandExecutionCallbackHandler)capturedOutput, cmdArray);
            if (res != 0) {
                if (this.isDeployment) {
                    ctx.logOutput("Warning: Non-zero exitcode  " + res);
                    ctx.logOutput("Warning: Check for Queue Manager \"" + this.wmqQueueManager.getQueueManagerName() + "\" running failed , Host might not support MQSC Commands");
                    ctx.logOutput("Warning: Step returning as success as Deployment will succeed with PCF commands if Queue Manager , Command Server and Listeners are running ");
                    boolean bl = true;
                    return bl;
                }
                ctx.logError("Non-zero exitcode  " + res);
                boolean bl = false;
                return bl;
            }
            for (String eachLine : capturedOutput.getOutputLines()) {
                String[] matches;
                if (!eachLine.startsWith("QMNAME") || (matches = RegexUtils.regexMatch(eachLine, "[\\s\\S]*(\\(Running\\))")) != null && matches.length != 0) continue;
                ctx.logOutput("starting QueueManager:\"" + this.wmqQueueManager.getQueueManagerName() + "\"");
                CapturingCommandExecutionCallbackHandler capturedOutput1 = new CapturingCommandExecutionCallbackHandler();
                res = hostSession.execute((CommandExecutionCallbackHandler)capturedOutput1, new String[]{"strmqm", this.wmqQueueManager.getQueueManagerName()});
                if (res == 0) continue;
                ctx.logError("Non-zero exitcode while starting Queue manager \"" + this.wmqQueueManager.getQueueManagerName() + "\" from " + res);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            hostSession.close();
        }
        ctx.logOutput("QueueManager \"" + this.wmqQueueManager.getQueueManagerName() + "\" is Running");
        return true;
    }

    public String getDescription() {
        if (this.wmqQueueManager.getQueueManagerName() != null) {
            return "Displaying the Status of QueueManager \"" + this.wmqQueueManager.getQueueManagerName() + "\"";
        }
        return "Displaying the QueueManager Status Step";
    }
}

