/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wmq.utils.RegexUtils;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class RetrieveWmqQueueManagerNamesStep
implements Step {
    private Host host;

    public RetrieveWmqQueueManagerNamesStep(Host host) {
        this.host = host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession hostSession = this.host.getHostSession();
        ArrayList<String> list = new ArrayList<String>();
        try {
            CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("dspmq");
            Object[] cmdArray = cmd.toArray(new String[cmd.size()]);
            int res = hostSession.execute((CommandExecutionCallbackHandler)capturedOutput, (String[])cmdArray);
            if (res != 0) {
                ctx.logError("Non-zero exitcode from " + StringUtils.join((Object[])cmdArray, (String)" ") + ": " + res);
                boolean bl = false;
                return bl;
            }
            for (String eachLine : capturedOutput.getOutputLines()) {
                String[] matches;
                if (!eachLine.startsWith("QMNAME") || (matches = RegexUtils.regexMatch(eachLine, "QMNAME\\((\\S+)\\)[\\s\\S]*")) == null || matches.length != 1) continue;
                list.add(matches[0]);
            }
        }
        finally {
            hostSession.close();
        }
        if (list.size() == 0) {
            ctx.logError("Queue Manager Names is not available");
            return false;
        }
        ctx.setAttribute("WmqQueueManagersNames", list);
        ctx.logOutput("Available Queue Manager Names on Host  \"" + this.host.getLabel() + "\"\n" + list);
        return true;
    }

    public String getDescription() {
        return "The QueueManagers present on the Host  \"" + this.host.getLabel() + "\" are retrieved here:";
    }
}

