/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultBindType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqGetMessages;
import com.xebialabs.deployit.plugin.wmq.enums.WmqScope;

@SuppressWarnings("serial")
public abstract class WmqBaseAliasQueue extends WmqQueue {

	@ConfigurationItemProperty(required = false, label = "GetMessages", description = "We can specify that whether we can get message on queue or not.We can specify this by choosing either get_Allowed or get_Inhibited options", size = Size.LARGE)
	private WmqGetMessages getMessages;

	@ConfigurationItemProperty(required = false, label = "Name of BaseObject", description = "Name of the Base Object.This value may be the name of a queue or topic which is already existed.", size = Size.LARGE)
	private String baseObject;

	@ConfigurationItemProperty(required = false, label = "Cluster Name", description = "Name of the Cluster.Only one value should be mentioned among ClusterName and ClusterNamelist  ", size = Size.LARGE, category = "Cluster")
	private String clusterName;

	@ConfigurationItemProperty(required = false, label = "Cluster Namelist", description = "Name of the Cluster Namelist.Only one value should be mentioned among ClusterName and ClusterNamelist ", size = Size.LARGE, category = "Cluster")
	private String clusterNamelist;

	@ConfigurationItemProperty(required = false, label = "Scope", description = "We can specify the scope of the queue either Cell or Queuemanager.", size = Size.LARGE)
	private WmqScope scope;

	@ConfigurationItemProperty(required = false, label = "Default Bind Type", description = "This parameter specifies the binding to be used when MQOO_BIND_AS_Q_DEF is specified on the MQOPEN call.", size = Size.LARGE, category = "Cluster")
	private WmqDefaultBindType defaultBindType;

	@ConfigurationItemProperty(required = false, label = "CLWL queue rank", description = "This parameter specifies the rank of the queue in cluster workload management in the range 0 to 9.", size = Size.LARGE, category = "Cluster")
	private int clwlQueueRank;

	@ConfigurationItemProperty(required = false, label = "CLWL queue priority", description = "This parameter specifies the priority of the queue in cluster workload management in the range 0 to 9.", size = Size.LARGE, category = "Cluster")
	private int clwlQueuePriority;

	public WmqGetMessages getGetMessages() {
		return getMessages;
	}

	public void setGetMessages(WmqGetMessages getMessages) {
		this.getMessages = getMessages;
	}

	public String getBaseObject() {
		return baseObject;
	}

	public void setBaseObject(String baseObject) {
		this.baseObject = baseObject;
	}

	public String getClusterName() {
		return clusterName;
	}

	public void setClusterName(String clusterName) {
		this.clusterName = clusterName;
	}

	public String getClusterNamelist() {
		return clusterNamelist;
	}

	public void setClusterNamelist(String clusterNamelist) {
		this.clusterNamelist = clusterNamelist;
	}

	public WmqScope getScope() {
		return scope;
	}

	public void setScope(WmqScope scope) {
		this.scope = scope;
	}

	public WmqDefaultBindType getDefaultBindType() {
		return defaultBindType;
	}

	public void setDefaultBindType(WmqDefaultBindType defaultBindType) {
		this.defaultBindType = defaultBindType;
	}

	public int getClwlQueueRank() {
		return clwlQueueRank;
	}

	public void setClwlQueueRank(int clwlQueueRank) {
		this.clwlQueueRank = clwlQueueRank;
	}

	public int getClwlQueuePriority() {
		return clwlQueuePriority;
	}

	public void setClwlQueuePriority(int clwlQueuePriority) {
		this.clwlQueuePriority = clwlQueuePriority;
	}

}
