/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLCipherSpec;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLClientAuthentication;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.utils.WMQConstants;

@SuppressWarnings("serial")
public class WmqChannel extends BaseConfigurationItem implements WmqResource {

	private String alterDate;
	private String alterTime;

	@ConfigurationItemProperty(required = true, label = "Channel name", identifying = true, description = "This is the name of the channel definition.")
	private String channelName;

	@ConfigurationItemProperty(label = "Channel Description", description = "Type a meaningful description of the purpose of the channel.")
	private String description;

	@ConfigurationItemProperty(required = true, label = "Transmission protocol")
	private WmqTransmissionProtocolTypes transportType;

	@ConfigurationItemProperty(label = "Header compression", description = "Header data compression techniques supported by the channel.", category = "Extended")
	private WmqHeaderCompression headerCompression;

	@ConfigurationItemProperty(label = "Heartbeat interval", description = "Type the length of the heartbeat interval, from 0 to 999 999", category = "Extended")
	private int heartBeatInterval = 300;

	@ConfigurationItemProperty(label = "Keep alive interval", description = "Type the length of the keep alive interval, from 0 to 99999.", category = "Extended")
	private int keepAliveInterval = WMQConstants.INTEGER_MAX_VALUE_SUPPORTED;

	@ConfigurationItemProperty(label = "Maximum message length", description = "The maximum message length is 100 MB (104 857 600 bytes)", category = "Extended")
	private int maximumMessageLength = 4194304;

	@ConfigurationItemProperty(label = "Send exit name", description = "Specifies the name of the exit program to be run by the channel send exit(Give multiple names with comma seperated).", category = "Exit")
	private String sendExit;

	@ConfigurationItemProperty(label = "Send exit user data", description = "Specifies user data that is passed to the send exit(Give multiple names with comma seperate).", category = "Exit")
	private String sendExitUserData;

	@ConfigurationItemProperty(label = "Receive exit name", description = "Channel receive exit name(Give multiple names with comma seperate).", category = "Exit")
	private String receiveExit;

	@ConfigurationItemProperty(label = "Receive exit user data", description = "Specifies user data that is passed to the receive exit(Give multiple names with comma seperate).", category = "Exit")
	private String receiveExitUserData;

	@ConfigurationItemProperty(label = "Security exit name", description = "Channel security exit name.", category = "Exit")
	private String securityExit;

	@ConfigurationItemProperty(label = "Security exit user data", description = "Specifies user data that is passed to the security exit.", category = "Exit")
	private String securityExitUserData;

	@ConfigurationItemProperty(label = "SSL CipherSpec", description = "It is valid only for channels with a transport type (TRPTYPE) of TCP. The SSLCIPH values must specify the same CipherSpec on both ends of the channel.", category = "SSL")
	private WmqSSLCipherSpec sslCipherSpecification;

	@ConfigurationItemProperty(label = "Athentication of parties initiating connections", description = "Defines whether WebSphere MQ requires a certificate from the SSL client. ", category = "SSL")
	private WmqSSLClientAuthentication sslClientAuth;

	public String getAlterDate() {
		return alterDate;
	}

	public void setAlterDate(String alterDate) {
		this.alterDate = alterDate;
	}

	public String getAlterTime() {
		return alterTime;
	}

	public void setAlterTime(String alterTime) {
		this.alterTime = alterTime;
	}

	public String getChannelName() {
		return channelName;
	}

	public void setChannelName(String channelName) {
		this.channelName = channelName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public WmqTransmissionProtocolTypes getTransportType() {
		return transportType;
	}

	public void setTransportType(WmqTransmissionProtocolTypes transportType) {
		this.transportType = transportType;
	}

	public WmqHeaderCompression getHeaderCompression() {
		return headerCompression;
	}

	public void setHeaderCompression(WmqHeaderCompression headerCompression) {
		this.headerCompression = headerCompression;
	}

	public int getHeartBeatInterval() {
		return heartBeatInterval;
	}

	public void setHeartBeatInterval(int heartBeatInterval) {
		this.heartBeatInterval = heartBeatInterval;
	}

	public int getKeepAliveInterval() {
		return keepAliveInterval;
	}

	public void setKeepAliveInterval(int keepAliveInterval) {
		this.keepAliveInterval = keepAliveInterval;
	}

	public int getMaximumMessageLength() {
		return maximumMessageLength;
	}

	public void setMaximumMessageLength(int maximumMessageLength) {
		this.maximumMessageLength = maximumMessageLength;
	}

	public String getSendExit() {
		return sendExit;
	}

	public void setSendExit(String sendExit) {
		this.sendExit = sendExit;
	}

	public String getSendExitUserData() {
		return sendExitUserData;
	}

	public void setSendExitUserData(String sendExitUserData) {
		this.sendExitUserData = sendExitUserData;
	}

	public String getReceiveExit() {
		return receiveExit;
	}

	public void setReceiveExit(String receiveExit) {
		this.receiveExit = receiveExit;
	}

	public String getReceiveExitUserData() {
		return receiveExitUserData;
	}

	public void setReceiveExitUserData(String receiveExitUserData) {
		this.receiveExitUserData = receiveExitUserData;
	}

	public String getSecurityExit() {
		return securityExit;
	}

	public void setSecurityExit(String securityExit) {
		this.securityExit = securityExit;
	}

	public String getSecurityExitUserData() {
		return securityExitUserData;
	}

	public void setSecurityExitUserData(String securityExitUserData) {
		this.securityExitUserData = securityExitUserData;
	}

	public WmqSSLCipherSpec getSslCipherSpecification() {
		return sslCipherSpecification;
	}

	public void setSslCipherSpecification(WmqSSLCipherSpec sslCipherSpecification) {
		this.sslCipherSpecification = sslCipherSpecification;
	}

	public WmqSSLClientAuthentication getSslClientAuth() {
		return sslClientAuth;
	}

	public void setSslClientAuth(WmqSSLClientAuthentication sslClientAuth) {
		this.sslClientAuth = sslClientAuth;
	}

}
