/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.ModificationSupportingMappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqResourceMapping;
import com.xebialabs.deployit.plugin.wmq.ci.WmqSubscriptions;
import com.xebialabs.deployit.plugin.wmq.step.CreateWmqSubscriptionStep;
import com.xebialabs.deployit.plugin.wmq.step.DestroyWmqSubscriptionStep;
import com.xebialabs.deployit.plugin.wmq.step.ModifyWmqSubscriptionStep;

public class WmqSubscriptionsToWmqQueueManagerMapper extends
        ModificationSupportingMappingAgnosticStepGeneratingMapper<WmqSubscriptions, WmqResourceMapping, WmqQueueManager> {

	public WmqSubscriptionsToWmqQueueManagerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WmqSubscriptions wmqsubscriptions, WmqQueueManager wmqqueuemanager, List<Step> steps) {
		steps.add(new CreateWmqSubscriptionStep(wmqsubscriptions, wmqqueuemanager));

	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WmqSubscriptions wmqsubscriptions, WmqQueueManager wmqqueuemanager, List<Step> steps) {
		steps.add(new DestroyWmqSubscriptionStep(wmqsubscriptions, wmqqueuemanager));

	}

	@Override
	protected void generateModificationStepsForModifiedMapping(WmqSubscriptions oldSubscriptions, WmqQueueManager oldQueueManager,
	        WmqSubscriptions newSubscriptions, WmqQueueManager newQueueManager, List<Step> steps) {

		steps.add(new ModifyWmqSubscriptionStep(newSubscriptions, newQueueManager));
	}

}
