/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

/**
 * <h2>The <a href="http://www.xebialabs.com/deployit-automated-deployment-java-applications">Deployit</a> 
 * plugin for WebSphere Message Queueing.</h2>
 * 
 * This is the standard Deployit plugin for functionality related to IBM WebSphere Message
 * Queueing (further referenced in this documentation as WMQ). It provides support 
 * for WMQ-specific components and allows users to work with WMQ objects in an WebsphereMQ Environment.
 * 
 * <h3>Supported middleware</h3>
 * 
 * This plugin supports WebSphere MQ(WMQ) versions from 6.0 to 7.0 
 * 
 * <h3>Requirements</h3>
 * 
 * The plugin executes its deployment and configuration tasks by connecting to the
 * target host systems and executing MQSC commands there.It also uses PCF Commands to execute the Configuration tasks.
 * This implies that the following
 * must be possible:
 * 
 * <ul>
 * <li>Creating a connection to the host on which the "deployment manager" is running, 
 * using the {@link com.xebialabs.deployit.ci.Host Host's} specified connection methods.
 * <li>Starting WMQ QueueManager on the target host server under the user Deployit uses 
 * to connect to the host (or the SUDO user, if specified).
 * </ul>
 * 
 * In addition, if the plugin is being used in an environment(For eg.,Windows,OS400,LINUX), in order 
 * to configure the WebSphere Message Queueing plugin:
 *  
 * <ul>
 * <li>The Working Environment where Deployit runs(For eg.,Windows,OS400,LINUX) must have installed 
 * and activated the correct version of the WMQ as that of WMQplugin (For Windows, see <a href="http://publib.boulder.ibm.com/infocenter/wmqv7/v7r0/index.jsp?topic=/com.ibm.mq.amqtac.doc/wq10120_.htm">IBM reference documentation</a>).
 * (For OS400(iseries), see <a href="http://publib.boulder.ibm.com/infocenter/wmqv7/v7r0/index.jsp?topic=/com.ibm.mq.amqwac.doc/iq10120_.htm">IBM refernce documentation</a>).
 * (For Linux, see <a href="http://publib.boulder.ibm.com/infocenter/wmqv7/v7r0/index.jsp?topic=/com.ibm.mq.amq1ac.doc/lq10120_.htm">IBM refernce documentation</a>).
 * <li>It must be possible to create a connection from the Deployit to the WebSphere MQ
 * being administered.
 * <li>The user under which Deployit connects to the WebSphere MQ(or the SUDO user, if
 * specified) must be able to create, modify and delete WMQ objects in the QueueManager
 * referred to above.
 * <li>This user must also be able to stop, start and restart QueueManager.
 * </ul>
 * 
 * <h3>Components</h3>
 * 
 * WMQ middleware environments are modelled on the basis of the following Configuration
 * Items (CIs):
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager WebSphere MQ Queue Manager}
 * </ul>
 * 
 * Further, the plugin provides CIs for the following WMQ-related resources:
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqLocalQueue WebSphere MQSeries  Local Queue}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqAliasQueue WebSphere MQSeries Alias Queue}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqRemoteQueue WebSphere MQSeries Remote Queue}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqModelQueue WebSphere MQSeries Model Queue}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqTopic WebSphere MQSeries Topic}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqSenderChannel WebSphere MQSeries Sender Channel}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqReceiverChannel WebSphere MQSeries Receiver Channel}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqClusterReceiverChannel WebSphere MQSeries ClusterReceiver Channel}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqClusterSenderChannel WebSphere MQSeries ClusterSender Channel}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqServerChannel WebSphere MQSeries Server Channel}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqRequesterChannel WebSphere MQSeries Requester Channel}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqServerConnectionChannel WebSphere MQSeries ServerConnection Channel}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqLU62Listener WebSphere MQSeries LU6Listener}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqNetBIOSListener WebSphere MQSeries NetBIOSListener}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqSPXListener WebSphere MQSeries SPXListener}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqTCPListener WebSphere MQSeries TCPListener}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqSubscriptions WebSphere MQSeries Subscription}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqNamelist WebSphere MQSeries Namelist}
 * <li>{@link com.xebialabs.deployit.plugin.wmq.ci.WmqProcessDefinition WebSphere MQSeries Process Definition}
 * </ul>
 * 
 * <h3>Supported scenarios</h3>
 * 
 * The plugin supports:
 * 
 * <ul>
 * <li>the initial deployment, re- and undeployment of deployment packages to/from WMQ environments
 * via the {@link com.xebialabs.deployit.plugin.wmq.runbook.WmqDeploymentRunBook WMQ Deployment RunBook}
 * </ul>
 * 
 * For details of the exact components supported, sequence in which steps are carried out, limitations
 * etc. please consult the documentation of the Deployment runbook.
 * 
 * <ul>
 * <li>The modification of Discovered TCPListener  
 * via {@link com.xebialabs.deployit.plugin.wmq.runbook.WmqTCPListenerRunBook WMQ TCPListener Runbook}
 * </ul>
 * 
 * <p>
 * All WMQ-related resources(say queues,listeners,etc.,)can be mapped with the {@link com.xebialabs.deployit.plugin.wmq.ci.WmqResourceMapping 
 * WMQ resource mapping} to:
 * 
 * <ul>
 * <li>a specified target WMQ QueueManager
 * {@link com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager WMQ Queue manager}.
 * </ul>
 * 
 * <h3>Known limitations</h3>
 * 
 * The plugin does not currently support
 * 
 * <ul>
 * <li>Installation, maintenance or removal of WebSphere MQ installations.
 * </ul>
 * 
 * If you have questions, comments or feedback please <a href="mailto:deployit-dev@xebialabs.com">contact</a>
 * the WebSphere development team at XebiaLabs.
 * 
 * @version 1.2
 */
package com.xebialabs.deployit.plugin.wmq;