/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqClusterReceiverChannel;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMCAType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDataConversion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonpersistentMessageSpeed;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLClientAuthentication;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

/**
 * Creates a {@link WmqClusterReceiverChannel} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqClusterReceiverChannelStep extends BaseWmqStep {

	public WmqClusterReceiverChannel wmqClusterReceiverChannel;

	public CreateWmqClusterReceiverChannelStep(WmqClusterReceiverChannel wmqClusterReceiverChannel, WmqQueueManager wmqQmanager) {

		this.wmqClusterReceiverChannel = wmqClusterReceiverChannel;
		this.wmqQmanager = wmqQmanager;
	}

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_CREATE_CHANNEL;

	}

	@Override
	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// Setting MQ ClusterReceiverChannel ChannelName
		pcfCmd.addParameter(MQConstants.MQCACH_CHANNEL_NAME, wmqClusterReceiverChannel.getChannelName());

		// Setting MQ ClusterReceiverChannel ChannelType
		pcfCmd.addParameter(MQConstants.MQIACH_CHANNEL_TYPE, MQConstants.MQCHT_CLUSRCVR);

		// Setting MQ ClusterReceiverChannel Channel Description
		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getDescription())) {

			pcfCmd.addParameter(MQConstants.MQCACH_DESC, wmqClusterReceiverChannel.getDescription());
		}

		// Setting MQ ClusterReceiverChannel Transport Type
		if (WmqTransmissionProtocolTypes.LU6 == wmqClusterReceiverChannel.getTransportType()) {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_LU62);
		} else if (WmqTransmissionProtocolTypes.NET_BIOS == wmqClusterReceiverChannel.getTransportType()) {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_NETBIOS);
		} else if (WmqTransmissionProtocolTypes.SPX == wmqClusterReceiverChannel.getTransportType()) {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_SPX);
		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_TCP);
		}

		// Setting MQ ClusterReceiverChannel Connection name
		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getConnectionName())) {

			pcfCmd.addParameter(MQConstants.MQCACH_CONNECTION_NAME, wmqClusterReceiverChannel.getConnectionName());
		}

		// Setting MQ ClusterReceiverChannel Local communications address
		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getLocalCommunicationAddress())) {

			pcfCmd.addParameter(MQConstants.MQCACH_LOCAL_ADDRESS, wmqClusterReceiverChannel.getLocalCommunicationAddress());
		}

		// Setting MQ ClusterReceiverChannel HeaderCompression value
		if (WmqHeaderCompression.SYSTEM == wmqClusterReceiverChannel.getHeaderCompression()) {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_SYSTEM;

			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		} else {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_NONE;

			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		}

		// Setting MQ ClusterReceiverChannel MaximumMessageLength
		pcfCmd.addParameter(MQConstants.MQIACH_MAX_MSG_LENGTH, wmqClusterReceiverChannel.getMaximumMessageLength());

		// Setting MQ ClusterReceiverChannel MessageCompression Value
		int[] messageCompressionList = new int[1];
		if (WmqMessageCompression.RLE == wmqClusterReceiverChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_RLE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqMessageCompression.ZLIBFAST == wmqClusterReceiverChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBFAST;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqMessageCompression.ZLIBHIGH == wmqClusterReceiverChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBHIGH;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		} else {
			messageCompressionList[0] = MQConstants.MQCOMPRESS_NONE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		}

		// Setting MQ ClusterReceiverChannel KeepaliveInterval
		if (wmqClusterReceiverChannel.getKeepAliveInterval() > -1 && wmqClusterReceiverChannel.getKeepAliveInterval() <= 99999) {
			pcfCmd.addParameter(MQConstants.MQIACH_KEEP_ALIVE_INTERVAL, wmqClusterReceiverChannel.getKeepAliveInterval());
		}

		// Setting MQ ClusterReceiverChannel NonPersistentMessageSpeed
		if (WmqNonpersistentMessageSpeed.NORMAL == wmqClusterReceiverChannel.getNonPersistentMessageSpeed()) {

			pcfCmd.addParameter(MQConstants.MQIACH_NPM_SPEED, MQConstants.MQNPMS_NORMAL);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_NPM_SPEED, MQConstants.MQNPMS_FAST);
		}

		// Setting MQ ClusterReceiverChannel BatchSize
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_SIZE, wmqClusterReceiverChannel.getBatchSize());

		// Setting MQ ClusterReceiverChannel BatchInterval
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_INTERVAL, wmqClusterReceiverChannel.getBatchInterval());

		// Setting MQ ClusterReceiverChannel DisconnectInterval
		pcfCmd.addParameter(MQConstants.MQIACH_DISC_INTERVAL, wmqClusterReceiverChannel.getDisconnectInterval());

		// Setting MQ ClusterReceiverChannel DataConversion value
		if (WmqDataConversion.CONVERSION == wmqClusterReceiverChannel.getDataConversion()) {

			pcfCmd.addParameter(MQConstants.MQIACH_DATA_CONVERSION, MQConstants.MQCDC_SENDER_CONVERSION);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_DATA_CONVERSION, MQConstants.MQCDC_NO_SENDER_CONVERSION);
		}

		// Setting MQ ClusterReceiverChannel BatchHeartBeatInterval
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_HB, wmqClusterReceiverChannel.getBatchHeartBeatInterval());

		if (wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
			// Setting MQ ClusterReceiverChannel PropertyControl
			if (WmqChannelPropertyControl.ALL == wmqClusterReceiverChannel.getPropertyControl()) {

				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_ALL);

			} else if (WmqChannelPropertyControl.NONE == wmqClusterReceiverChannel.getPropertyControl()) {

				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_NONE);

			} else {
				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_COMPATIBILITY);
			}
		}

		// Setting MQ ClusterReceiverChannel MessageRetryCount
		pcfCmd.addParameter(MQConstants.MQIACH_MR_COUNT, wmqClusterReceiverChannel.getMessageRetryCount());

		// Setting MQ ClusterReceiverChannel MessageRetryInterval
		pcfCmd.addParameter(MQConstants.MQIACH_MR_INTERVAL, wmqClusterReceiverChannel.getMessageRetryInterval());

		// Setting MQ ClusterReceiverChannel MessageRetryExitname

		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getMessageRetryExitname())) {

			pcfCmd.addParameter(MQConstants.MQCACH_MR_EXIT_NAME, wmqClusterReceiverChannel.getMessageRetryExitname());

		}

		// Setting MQ ClusterReceiverChannel MessageRetryExitUserData
		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getMessageRetryExitUserData())) {

			pcfCmd.addParameter(MQConstants.MQCACH_MR_EXIT_USER_DATA, wmqClusterReceiverChannel.getMessageRetryExitUserData());

		}

		// Setting MQ ClusterReceiverChannel ClusterName
		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getClusterName())) {

			pcfCmd.addParameter(MQConstants.MQCA_CLUSTER_NAME, wmqClusterReceiverChannel.getClusterName());

		}

		// Setting MQ ClusterReceiverChannel ClusterNamelist
		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getClusterNamelist())) {

			pcfCmd.addParameter(MQConstants.MQCA_CLUSTER_NAMELIST, wmqClusterReceiverChannel.getClusterNamelist());

		}

		// Setting MQ ClusterReceiverChannel Network priority
		pcfCmd.addParameter(MQConstants.MQIACH_NETWORK_PRIORITY, wmqClusterReceiverChannel.getNetworkPriority());

		// Setting MQ ClusterReceiverChannel Channel rank for the purposes of
		// cluster workload distribution
		pcfCmd.addParameter(MQConstants.MQIACH_CLWL_CHANNEL_RANK, wmqClusterReceiverChannel.getClusterWorkloadChannelRank());

		// Setting MQ ClusterReceiverChannel Channel priority
		pcfCmd.addParameter(MQConstants.MQIACH_CLWL_CHANNEL_PRIORITY, wmqClusterReceiverChannel.getClusterWorkloadChannelPriority());

		// Setting MQ ClusterReceiverChannel Channel weighting
		pcfCmd.addParameter(MQConstants.MQIACH_CLWL_CHANNEL_WEIGHT, wmqClusterReceiverChannel.getClusterWorkloadChannelWeight());

		// Setting MQ ClusterReceiverChannel MCAUserID
		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getMcaUserID())) {

			pcfCmd.addParameter(MQConstants.MQCACH_MCA_USER_ID, wmqClusterReceiverChannel.getMcaUserID());

		}

		// Setting MQ ClusterReceiverChannel MCAType
		if (WmqChannelMCAType.THREAD == wmqClusterReceiverChannel.getMcaType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_MCA_TYPE, MQConstants.MQMCAT_THREAD);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_MCA_TYPE, MQConstants.MQMCAT_PROCESS);
		}

		// Setting MQ ClusterReceiverChannel SendExitname
		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getSendExit())) {

			String[] sendExitList = StringUtils.split(wmqClusterReceiverChannel.getSendExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_NAME, sendExitList);

		}

		// Setting MQ ClusterReceiverChannel SendExitUserData
		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getSendExitUserData())) {

			String[] sendExitUserDataList = StringUtils.split(wmqClusterReceiverChannel.getSendExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_USER_DATA, sendExitUserDataList);
		}

		// Setting MQ ClusterReceiverChannel ReceiveExit
		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getReceiveExit())) {

			String[] receiveExitList = StringUtils.split(wmqClusterReceiverChannel.getReceiveExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_NAME, receiveExitList);
		}

		// Setting MQ ClusterReceiverChannel ReceiveUserData
		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getReceiveExitUserData())) {

			String[] receiveExitUserDataList = StringUtils.split(wmqClusterReceiverChannel.getReceiveExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_USER_DATA, receiveExitUserDataList);
		}

		// Setting MQ ClusterReceiverChannel SecurityExit
		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getSecurityExit())) {
			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_NAME, wmqClusterReceiverChannel.getSecurityExit());
		}

		// Setting MQ ClusterReceiverChannel SecurityUserData
		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getSecurityExitUserData())) {

			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_USER_DATA, wmqClusterReceiverChannel.getSecurityExitUserData());
		}

		// Setting MQ ClusterReceiverChannel MsgExit

		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getMessageExitName())) {

			String[] messageExitList = StringUtils.split(wmqClusterReceiverChannel.getMessageExitName(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_MSG_EXIT_NAME, messageExitList);
		}

		// Setting MQ ClusterReceiverChannel MsgExitUserData

		if (StringUtils.isNotBlank(wmqClusterReceiverChannel.getMessageExitUserData())) {

			String[] messageExitUserList = StringUtils.split(wmqClusterReceiverChannel.getMessageExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_MSG_EXIT_USER_DATA, messageExitUserList);
		}

		// Setting MQ ClusterReceiverChannel ShortRetryCount
		pcfCmd.addParameter(MQConstants.MQIACH_SHORT_RETRY, wmqClusterReceiverChannel.getShortRetryCount());

		// Setting MQ ClusterReceiverChannel ShortRetryInterval
		pcfCmd.addParameter(MQConstants.MQIACH_SHORT_TIMER, wmqClusterReceiverChannel.getShortRetryInterval());

		// Setting MQ ClusterReceiverChannel LongRetryCount
		pcfCmd.addParameter(MQConstants.MQIACH_LONG_RETRY, wmqClusterReceiverChannel.getLongRetryCount());

		// Setting MQ ClusterReceiverChannel LongRetryInterval
		pcfCmd.addParameter(MQConstants.MQIACH_LONG_TIMER, wmqClusterReceiverChannel.getLongRetryInterval());

		// Setting MQ ClusterReceiverChannel Monitoring
		if (WmqChannelMonitoring.HIGH == wmqClusterReceiverChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_HIGH);

		} else if (WmqChannelMonitoring.LOW == wmqClusterReceiverChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_LOW);

		} else if (WmqChannelMonitoring.MEDIUM == wmqClusterReceiverChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_MEDIUM);

		} else if (WmqChannelMonitoring.OFF == wmqClusterReceiverChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_OFF);

		} else {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_Q_MGR);
		}

		// Setting MQ ClusterReceiverChannel Statistics
		if (WmqChannelStatisticTypes.HIGH == wmqClusterReceiverChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_HIGH);

		} else if (WmqChannelStatisticTypes.LOW == wmqClusterReceiverChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_LOW);

		} else if (WmqChannelStatisticTypes.MEDIUM == wmqClusterReceiverChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_MEDIUM);

		} else if (WmqChannelStatisticTypes.OFF == wmqClusterReceiverChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_OFF);

		} else {
			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_Q_MGR);
		}

		// Setting MQ ClusterReceiverChannel SSLCipherSpec
		if (wmqClusterReceiverChannel.getSslCipherSpecification() != null) {

			pcfCmd.addParameter(MQConstants.MQCACH_SSL_CIPHER_SPEC, wmqClusterReceiverChannel.getSslCipherSpecification().toString());
		}

		// Setting MQ ClusterReceiverChannel Client authentication
		if (WmqSSLClientAuthentication.OPTIONAL == wmqClusterReceiverChannel.getSslClientAuth()) {

			pcfCmd.addParameter(MQConstants.MQIACH_SSL_CLIENT_AUTH, MQConstants.MQSCA_OPTIONAL);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_SSL_CLIENT_AUTH, MQConstants.MQSCA_REQUIRED);
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating ClusterReceiverChannel \"" + wmqClusterReceiverChannel.getChannelName() + "\" is created on QueueManager \""
			        + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Creating ClusterReceiverChannel Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The ClusterReceiverChannel \"" + wmqClusterReceiverChannel.getChannelName() + "\" is created on QueueManager \""
		        + this.wmqQmanager.getQueueManagerName() + "\"";
	}

}
